<?php
header('Content-Type: text/html; charset=utf-8');
mb_internal_encoding('UTF-8');
error_reporting(E_ALL);
ini_set('display_errors', 1);

// view_excel.php - Complete Excel Data Viewer without documents
$excel_file = "admissions_data.csv";
echo "<!DOCTYPE html>";
echo "<html dir='rtl'>";
echo "<head>";
echo "<meta charset='UTF-8'>";
echo "<title>جامعہ دارالعلوم حقانیہ - داخلہ فارمز کا ڈیٹا</title>";
echo "<link rel='stylesheet' href='https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css'>";
echo "<style>
    body { 
        font-family: 'Noto Naskh Arabic', 'Jameel Noori Nastaleeq', serif; 
        padding: 20px; 
        background: #f5f5f5; 
        direction: rtl; 
        margin: 0;
    }
    .header { 
        background: linear-gradient(135deg, #1a472a 0%, #0d2416 100%);
        color: white; 
        padding: 30px; 
        text-align: center; 
        margin-bottom: 30px; 
        border-radius: 15px; 
        box-shadow: 0 5px 15px rgba(0,0,0,0.2);
    }
    .header h1 {
        font-size: 2.2rem;
        margin-bottom: 10px;
        color: #d4af37;
    }
    .header p {
        font-size: 1.2rem;
        opacity: 0.9;
    }
    .container { 
        max-width: 100%; 
        overflow-x: auto; 
        background: white;
        border-radius: 10px;
        box-shadow: 0 5px 20px rgba(0,0,0,0.1);
        padding: 20px;
    }
    table { 
        border-collapse: collapse; 
        width: 100%; 
        background: white; 
        font-size: 1rem;
    }
    th { 
        background-color: #1a472a; 
        color: white; 
        padding: 15px 10px; 
        text-align: right; 
        font-size: 1rem;
        position: sticky; 
        top: 0; 
        z-index: 10;
        white-space: nowrap;
    }
    td { 
        border: 1px solid #ddd; 
        padding: 12px 10px; 
        text-align: right; 
        white-space: nowrap;
    }
    tr:nth-child(even) { 
        background-color: #f8f9fa; 
    }
    tr:hover { 
        background-color: #e9ecef; 
    }
    .serial { 
        font-weight: bold; 
        color: #1a472a; 
        background: #e8f5e9; 
    }
    .btn {
        padding: 12px 30px;
        border: none;
        border-radius: 50px;
        font-size: 1.1rem;
        cursor: pointer;
        transition: all 0.3s;
        text-decoration: none;
        display: inline-block;
        margin: 5px;
    }
    .btn-download {
        background: #1a472a;
        color: white;
    }
    .btn-print {
        background: #d4af37;
        color: black;
    }
    .btn:hover {
        transform: translateY(-3px);
        box-shadow: 0 5px 15px rgba(0,0,0,0.2);
    }
    .stats {
        background: white;
        padding: 20px;
        border-radius: 10px;
        margin-bottom: 20px;
        display: flex;
        justify-content: space-around;
        flex-wrap: wrap;
    }
    .stat-box {
        text-align: center;
        padding: 15px 25px;
        background: #f8f9fa;
        border-radius: 10px;
        border-right: 4px solid #d4af37;
    }
    .stat-number {
        font-size: 2rem;
        font-weight: bold;
        color: #1a472a;
    }
    .stat-label {
        color: #666;
        font-size: 1rem;
    }
    @media print {
        .btn, .stats, .header { display: none; }
        body { background: white; }
        .container { box-shadow: none; padding: 0; }
    }
</style>";
echo "</head>";
echo "<body>";

echo "<div class='header'>";
echo "<h1><i class='fas fa-mosque'></i> جامعہ دارالعلوم حقانیہ</h1>";
echo "<h2>داخلہ فارمز کا مکمل ڈیٹا</h2>";
echo "<p>تاریخ: " . date('d/m/Y') . " | وقت: " . date('h:i A') . "</p>";
echo "</div>";

if (file_exists($excel_file)) {
    $fp = fopen($excel_file, 'r');
    
    // Count total records
    $total_records = 0;
    while (fgetcsv($fp) !== FALSE) {
        $total_records++;
    }
    $total_records--; // Subtract header row
    rewind($fp);
    
    // Stats Section
    echo "<div class='stats'>";
    echo "<div class='stat-box'><div class='stat-number'>" . $total_records . "</div><div class='stat-label'>کل اندراج</div></div>";
    echo "<div class='stat-box'><div class='stat-number'>" . date('Y') . "</div><div class='stat-label'>تعلیمی سال</div></div>";
    echo "<div class='stat-box'><div class='stat-number'>5</div><div class='stat-label'>تازہ ترین</div></div>";
    echo "</div>";
    
    echo "<div class='container'>";
    echo "<table>";
    
    // ============================================
    // SIMPLE HEADERS - SIRF REQUIRED FIELDS
    // ============================================
    echo "<tr>";
    echo "<th>#</th>";
    echo "<th>سیریل نمبر</th>";
    echo "<th>تاریخ جمع</th>";
    echo "<th>نام</th>";
    echo "<th>والد کا نام</th>";
    echo "<th>تاریخ پیدائش</th>";
    echo "<th>موبائل</th>";
    echo "<th>ای میل</th>";
    echo "<th>ضلع</th>";
    echo "<th>مستقل پتہ</th>";
    echo "<th>موجودہ پتہ</th>";
    echo "<th>مطلوبہ شعبہ</th>";
    echo "<th>سرپرست نام</th>";
    echo "<th>سرپرست نمبر</th>";
    echo "<th>سابقہ مدرسہ</th>";
    echo "<th>سابقہ درجہ</th>";
    echo "<th>وفاق رول نمبر</th>";
    echo "<th>حاصل کردہ نمبرات</th>";
    echo "<th>فیصد</th>";
    echo "<th>عصری تعلیم</th>";
    echo "</tr>";
    
    // Skip original headers
    $original_headers = fgetcsv($fp);
    
    // ============================================
    // SIMPLE DATA ROWS - SIRF REQUIRED FIELDS, NO DOCUMENTS
    // ============================================
    $row_number = 1;
    while (($row = fgetcsv($fp)) !== FALSE) {
        // Skip empty rows
        if (empty(array_filter($row))) continue;
        
        echo "<tr>";
        
        // Row number
        echo "<td style='font-weight: bold; color: #d4af37;'>" . $row_number++ . "</td>";
        
        // Column 0: Student ID with SR- format
        $student_id = $row[0] ?? '';
        if (is_numeric($student_id) && strpos($student_id, 'SR-') === false) {
            $student_id = "SR-" . $student_id;
        }
        echo "<td class='serial'><strong>" . htmlspecialchars($student_id) . "</strong></td>";
        
        // Column 1: Date
        $date = isset($row[1]) ? date('d-m-Y', strtotime($row[1])) : '';
        echo "<td>" . $date . "</td>";
        
        // Column 2: Student Name
        echo "<td>" . htmlspecialchars($row[2] ?? '') . "</td>";
        
        // Column 3: Father Name
        echo "<td>" . htmlspecialchars($row[3] ?? '') . "</td>";
        
        // Column 13: Date of Birth
        $dob = isset($row[13]) ? date('d-m-Y', strtotime($row[13])) : '';
        echo "<td>" . $dob . "</td>";
        
        // Column 7: Phone
        echo "<td>" . htmlspecialchars($row[7] ?? '') . "</td>";
        
        // Column 8: Email
        echo "<td>" . htmlspecialchars($row[8] ?? '') . "</td>";
        
        // Column 14: District
        echo "<td>" . htmlspecialchars($row[14] ?? '') . "</td>";
        
        // Column 4: Permanent Address
        echo "<td>" . htmlspecialchars($row[4] ?? '') . "</td>";
        
        // Column 5: Current Address
        echo "<td>" . htmlspecialchars($row[5] ?? '') . "</td>";
        
        // Column 9: Course Applied
        echo "<td>" . htmlspecialchars($row[9] ?? '') . "</td>";
        
        // Column 6: Guardian Name
        echo "<td>" . htmlspecialchars($row[6] ?? '') . "</td>";
        
        // Column 17: Guardian Phone (agar hai to)
        $guardian_phone = isset($row[17]) ? $row[17] : '';
        echo "<td>" . htmlspecialchars($guardian_phone) . "</td>";
        
        // Column 18: Previous Madrassa
        $prev_madrassa = isset($row[18]) ? $row[18] : '';
        echo "<td>" . htmlspecialchars($prev_madrassa) . "</td>";
        
        // Column 19: Previous Class
        $prev_class = isset($row[19]) ? $row[19] : '';
        echo "<td>" . htmlspecialchars($prev_class) . "</td>";
        
        // Column 20: Wafaq Roll No
        $wafaq = isset($row[20]) ? $row[20] : '';
        echo "<td>" . htmlspecialchars($wafaq) . "</td>";
        
        // Column 21: Obtained Marks
        $marks = isset($row[21]) ? $row[21] : '';
        echo "<td>" . htmlspecialchars($marks) . "</td>";
        
        // Column 22: Percentage
        $percentage = isset($row[22]) ? $row[22] : '';
        echo "<td>" . htmlspecialchars($percentage) . "</td>";
        
        // Column 23: Modern Education
        $modern = isset($row[23]) ? $row[23] : '';
        echo "<td>" . htmlspecialchars($modern) . "</td>";
        
        echo "</tr>";
    }
    
    echo "</table>";
    echo "</div>";
    fclose($fp);
    
    // Buttons
    echo "<br><br>";
    echo "<div style='text-align: center; margin: 30px 0;'>";
    echo "<a href='$excel_file' download class='btn btn-download'><i class='fas fa-download'></i> CSV ڈاؤن لوڈ کریں</a>";
    echo "<button onclick='window.print()' class='btn btn-print'><i class='fas fa-print'></i> پرنٹ کریں</button>";
    echo "<button onclick='window.location.reload()' class='btn' style='background: #6c757d; color: white;'><i class='fas fa-sync-alt'></i> تازہ کریں</button>";
    echo "</div>";
    
} else {
    echo "<div style='text-align: center; padding: 100px; background: white; border-radius: 10px;'>";
    echo "<i class='fas fa-database' style='font-size: 5rem; color: #ddd;'></i>";
    echo "<p style='color: red; font-size: 1.5rem; margin-top: 20px;'>ابھی تک کوئی ڈیٹا موجود نہیں ہے۔</p>";
    echo "<a href='admission.php' style='background: #1a472a; color: white; padding: 15px 40px; text-decoration: none; border-radius: 50px; display: inline-block; margin-top: 20px;'><i class='fas fa-plus'></i> نیا اندراج کریں</a>";
    echo "</div>";
}

echo "</body>";
echo "</html>";
?>