<?php
require_once 'dompdf/autoload.inc.php';

use Dompdf\Dompdf;
use Dompdf\Options;

// Get student ID
$student_id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

// Database connection
define('DB_HOST', 'localhost');
define('DB_USER', 'daruwubs_madrassa_db');
define('DB_PASS', 'Khan(1234)@');
define('DB_NAME', 'daruwubs_admission.php');

$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
if ($conn->connect_error) die("Connection failed");

// Fetch student data
$student = null;
if ($student_id > 0) {
    $stmt = $conn->prepare("SELECT * FROM students WHERE id = ?");
    $stmt->bind_param("i", $student_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $student = $result->fetch_assoc();
    $stmt->close();
}
$conn->close();

// HTML content for PDF
$html = '<!DOCTYPE html>
<html lang="ur" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>داخلہ فارم</title>
    <style>
        body {
            font-family: "Noto Naskh Arabic", serif;
            padding: 30px;
        }
        .form-page {
            width: 100%;
            border: 2px solid #000;
            padding: 30px;
        }
        .header-top {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
        }
        .photo-box {
            width: 120px;
            height: 140px;
            border: 1px solid #000;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .institute-name-calligraphy {
            text-align: center;
            font-size: 32px;
            font-weight: bold;
            margin: 20px 0;
        }
        .row {
            display: flex;
            margin: 10px 0;
        }
        .label {
            font-weight: bold;
            min-width: 100px;
        }
        .line {
            border-bottom: 1px dotted #000;
            flex-grow: 1;
            margin-right: 10px;
        }
    </style>
</head>
<body>
<div class="form-page">
    <div class="header-top">
        <div class="photo-box">
            ' . ($student && file_exists($student['photo_path']) ? '<img src="' . $student['photo_path'] . '" width="100%">' : 'تصویر') . '
        </div>
        <div style="text-align: center;">
            <div style="font-size: 20px;">بسم اللہ الرحمن الرحیم</div>
            <div style="background: #000; color: #fff; padding: 5px 30px; border-radius: 50px;">داخلہ فارم</div>
        </div>
        <div class="logo-box">لوگو</div>
    </div>

    <div class="institute-name-calligraphy">جامعہ دارالعلوم حقانیہ</div>
    <div style="text-align: center;">اکوڑہ خٹک ضلع نوشہرہ</div>

    <div class="row">
        <span class="label">مطلوبہ درجہ:</span>
        <div class="line">' . $student['course_applied'] . '</div>
    </div>

    <div class="row">
        <span class="label">سیریل نمبر:</span>
        <div class="line">' . $student['id'] . '</div>
        <span class="label">رجسٹریشن نمبر:</span>
        <div class="line">DUH-' . date('Y') . '-' . str_pad($student['id'], 4, '0', STR_PAD_LEFT) . '</div>
    </div>

    <div style="margin: 20px 0;">
        بخدمت جناب اقدس حضرت مہتمم صاحب زید مجدکم! السلام علیکم ورحمۃ اللہ وبرکاتہ! <br>
        اما بعد: خدمت عالیہ میں داخلہ کی استدعا کرتے ہوئے صدق دل سے اقرار کرتا ہوں...
    </div>

    <div class="row">
        <span class="label">دستخط:</span>
        <div class="line"></div>
        <span class="label">تاریخ:</span>
        <div class="line">' . date('d/m/Y') . '</div>
    </div>

    <div style="background: #000; color: #fff; text-align: center; margin: 20px 0; padding: 5px;">تعارف</div>

    <div class="row">
        <span class="label">نام:</span>
        <div class="line">' . $student['student_name'] . '</div>
        <span class="label">ولدیت:</span>
        <div class="line">' . $student['father_name'] . '</div>
    </div>

    <div class="row">
        <span class="label">موبائل نمبر:</span>
        <div class="line">' . $student['phone'] . '</div>
        <span class="label">پتہ:</span>
        <div class="line">' . $student['permanent_address'] . '</div>
    </div>
</div>
</body>
</html>';

// Create PDF
$options = new Options();
$options->set('isHtml5ParserEnabled', true);
$options->set('isRemoteEnabled', true);

$dompdf = new Dompdf($options);
$dompdf->loadHtml($html);
$dompdf->setPaper('A4', 'portrait');
$dompdf->render();

// Download PDF
$dompdf->stream("admission_form_".$student_id.".pdf", array("Attachment" => 1));
exit;
?>