<?php
// submit.php - Updated with all new fields

error_reporting(E_ALL);
ini_set('display_errors', 1);

// ============ DATABASE CONFIG ============
define('DB_HOST', 'localhost');
define('DB_USER', 'daruwubs_madrassa_db');
define('DB_PASS', 'Khan(1234)@');
define('DB_NAME', 'daruwubs_admission.php');
// =========================================

// Create connection
$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
if ($conn->connect_error) {
    die("System mein technical problem hai. Thodi der baad try karein.");
}
$conn->set_charset("utf8mb4");

// Create students table if not exists (with all new fields)
$sql = "CREATE TABLE IF NOT EXISTS students (
    id INT AUTO_INCREMENT PRIMARY KEY,
    student_name VARCHAR(255) NOT NULL,
    father_name VARCHAR(255) NOT NULL,
    permanent_address TEXT NOT NULL,
    current_address TEXT NOT NULL,
    guardian_name VARCHAR(255) NOT NULL,
    phone VARCHAR(20) NOT NULL,
    email VARCHAR(255),
    course_applied VARCHAR(100) NOT NULL,
    photo_path VARCHAR(500),
    id_card_path VARCHAR(500),
    certificate_path VARCHAR(500),
    cnic_number VARCHAR(20) NULL,
    submission_date TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    dob DATE NULL,
    district VARCHAR(100) NULL,
    country VARCHAR(100) NULL,
    previous_madrasa_address TEXT NULL,
    previous_class VARCHAR(100) NULL,
    wifaq_roll_no VARCHAR(50) NULL,
    obtained_marks VARCHAR(50) NULL,
    division VARCHAR(10) NULL,
    asri_taleem VARCHAR(255) NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";

if ($conn->query($sql) !== TRUE) {
    die("System setup mein problem hai. Admin se rabta karein.");
}

// Handle form submission
if (isset($_POST['submit_application'])) {
    
    // ============================================
    // STEP 1: TEMPORARY FOLDER BANAO
    // ============================================
    $upload_base = "uploads";
    if (!file_exists($upload_base)) {
        if (!mkdir($upload_base, 0755, true)) {
            die("Upload folder nahi ban sakta. Admin se rabta karein.");
        }
    }
    
    $temp_folder = $upload_base . "/temp_" . date('Y-m-d') . "/";
    if (!file_exists($temp_folder)) {
        if (!mkdir($temp_folder, 0755, true)) {
            die("Temporary folder nahi ban sakta. Admin se rabta karein.");
        }
    }
    
    // ============================================
    // STEP 2: FILES UPLOAD KARO CHECKS KE SAATH
    // ============================================
    
    // Allowed file types
    $allowed_images = ['image/jpeg', 'image/jpg', 'image/png'];
    $max_size = 2 * 1024 * 1024; // 2MB
    
    // Upload Photo with checks
    $photo_path = "";
    if (isset($_FILES['photo']) && $_FILES['photo']['error'] == 0) {
        
        // File type check
        if (!in_array($_FILES['photo']['type'], $allowed_images)) {
            die("Photo sirf JPEG ya PNG format mein allow hai.");
        }
        
        // File size check
        if ($_FILES['photo']['size'] > $max_size) {
            die("Photo ka size 2MB se zyada nahi hona chahiye.");
        }
        
        $photo_ext = pathinfo($_FILES['photo']['name'], PATHINFO_EXTENSION);
        $photo_name = time() . "_photo_" . rand(1000, 9999) . "." . $photo_ext;
        $photo_path = $temp_folder . $photo_name;
        
        if (!move_uploaded_file($_FILES['photo']['tmp_name'], $photo_path)) {
            die("Photo upload nahi hui. Dobara try karein.");
        }
    }
    
    // Upload ID Card with checks
    $id_card_path = "";
    if (isset($_FILES['id_card']) && $_FILES['id_card']['error'] == 0) {
        
        // File type check
        if (!in_array($_FILES['id_card']['type'], $allowed_images)) {
            die("ID card sirf JPEG ya PNG format mein allow hai.");
        }
        
        // File size check
        if ($_FILES['id_card']['size'] > $max_size) {
            die("ID card ka size 2MB se zyada nahi hona chahiye.");
        }
        
        $idcard_ext = pathinfo($_FILES['id_card']['name'], PATHINFO_EXTENSION);
        $idcard_name = time() . "_idcard_" . rand(1000, 9999) . "." . $idcard_ext;
        $id_card_path = $temp_folder . $idcard_name;
        
        if (!move_uploaded_file($_FILES['id_card']['tmp_name'], $id_card_path)) {
            die("ID card upload nahi hua. Dobara try karein.");
        }
    }
    
    // Upload Certificate with checks
    $cert_path = "";
    if (isset($_FILES['previous_certificate']) && $_FILES['previous_certificate']['error'] == 0) {
        
        // File type check (images + PDF allow karo)
        $allowed_cert = ['image/jpeg', 'image/jpg', 'image/png', 'application/pdf'];
        if (!in_array($_FILES['previous_certificate']['type'], $allowed_cert)) {
            die("Certificate sirf JPEG, PNG ya PDF format mein allow hai.");
        }
        
        // File size check
        if ($_FILES['previous_certificate']['size'] > $max_size) {
            die("Certificate ka size 2MB se zyada nahi hona chahiye.");
        }
        
        $cert_ext = pathinfo($_FILES['previous_certificate']['name'], PATHINFO_EXTENSION);
        $cert_name = time() . "_cert_" . rand(1000, 9999) . "." . $cert_ext;
        $cert_path = $temp_folder . $cert_name;
        
        if (!move_uploaded_file($_FILES['previous_certificate']['tmp_name'], $cert_path)) {
            die("Certificate upload nahi hua. Dobara try karein.");
        }
    }
    
    // ============================================
    // STEP 3: DATABASE MEIN DATA INSERT KARO (UPDATED)
    // ============================================
    $stmt = $conn->prepare("INSERT INTO students 
    (student_name, father_name, permanent_address, current_address, guardian_name, 
     phone, email, course_applied, photo_path, id_card_path, certificate_path, 
     cnic_number,
     dob, district, country, previous_madrasa_address, previous_class, 
     wifaq_roll_no, obtained_marks, division, asri_taleem) 
    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
    
    if (!$stmt) {
        die("System error. Admin se rabta karein.");
    }
    
    $stmt->bind_param("sssssssssssssssssssss", 
        $_POST['student_name'],
        $_POST['father_name'],
        $_POST['permanent_address'],
        $_POST['current_address'],
        $_POST['guardian_name'],
        $_POST['phone'],
        $_POST['email'],
        $_POST['course_applied'],
        $photo_path,
        $id_card_path,
        $cert_path,
        $_POST['cnic_number'], 
        $_POST['dob'],
        $_POST['district'],
        $_POST['country'],
        $_POST['previous_madrasa_address'],
        $_POST['previous_class'],
        $_POST['wifaq_roll_no'],
        $_POST['obtained_marks'],
        $_POST['division'],
        $_POST['asri_taleem']
    );
    
    if ($stmt->execute()) {
        $student_id = $conn->insert_id;
        
        // ============================================
        // STEP 4: STUDENT KA PERMANENT FOLDER BANAO
        // ============================================
        $student_folder = $upload_base . "/SR-" . $student_id . "/";
        if (!file_exists($student_folder)) {
            if (!mkdir($student_folder, 0755, true)) {
                die("Student folder nahi ban sakta. Admin se rabta karein.");
            }
        }
        
        // ============================================
        // STEP 5: FILES MOVE KARO PERMANENT FOLDER MEIN
        // ============================================
        
        // Photo move karo
        if (!empty($photo_path) && file_exists($photo_path)) {
            $new_photo = $student_folder . basename($photo_path);
            if (!rename($photo_path, $new_photo)) {
                die("Files move nahi ho sakin. Admin se rabta karein.");
            }
            $photo_path = $new_photo;
        }
        
        // ID Card move karo
        if (!empty($id_card_path) && file_exists($id_card_path)) {
            $new_idcard = $student_folder . basename($id_card_path);
            rename($id_card_path, $new_idcard);
            $id_card_path = $new_idcard;
        }
        
        // Certificate move karo
        if (!empty($cert_path) && file_exists($cert_path)) {
            $new_cert = $student_folder . basename($cert_path);
            rename($cert_path, $new_cert);
            $cert_path = $new_cert;
        }
        
        // ============================================
        // STEP 6: DATABASE UPDATE KARO
        // ============================================
        $update = $conn->prepare("UPDATE students SET photo_path=?, id_card_path=?, certificate_path=? WHERE id=?");
        $update->bind_param("sssi", $photo_path, $id_card_path, $cert_path, $student_id);
        $update->execute();
        $update->close();
        
        // ============================================
        // STEP 6.5: CSV FILE WITH URDU/ENGLISH SUPPORT (UPDATED)
        // ============================================
        function createStudentCSV($student_id, $student_folder, $data) {
            
            $csv_file = $student_folder . "student_data_" . $student_id . ".csv";
            
            $fp = fopen($csv_file, 'w');
            
            // UTF-8 BOM for Urdu support
            fprintf($fp, chr(0xEF).chr(0xBB).chr(0xBF));
            
            // Headings in Urdu
            fputcsv($fp, ['جامعہ دارالعلوم حقانیہ']);
            fputcsv($fp, ['طالب علم کا مکمل ریکارڈ']);
            fputcsv($fp, []);
            
            // Student data (UPDATED with new fields)
            fputcsv($fp, ['شمارہ', $student_id]);
            fputcsv($fp, ['نام', $data['student_name']]);
            fputcsv($fp, ['ولدیت', $data['father_name']]);
            fputcsv($fp, ['تاریخ پیدائش', $data['dob']]);
            fputcsv($fp, ['ضلع', $data['district']]);
            fputcsv($fp, ['ملک', $data['country']]);
            fputcsv($fp, ['سرپرست', $data['guardian_name']]);
            fputcsv($fp, ['موبائل', $data['phone']]);
            fputcsv($fp, ['ای میل', $data['email']]);
            fputcsv($fp, ['مستقل پتہ', $data['permanent_address']]);
            fputcsv($fp, ['موجودہ پتہ', $data['current_address']]);
            fputcsv($fp, ['مطلوبہ درجہ', $data['course_applied']]);
            fputcsv($fp, ['سابقہ مدرسے کا پتہ', $data['previous_madrasa_address']]);
            fputcsv($fp, ['سابقہ درجہ', $data['previous_class']]);
            fputcsv($fp, ['وفاق کا رول نمبر', $data['wifaq_roll_no']]);
            fputcsv($fp, ['حاصل کردہ نمبرات', $data['obtained_marks']]);
            fputcsv($fp, ['تقدیر', $data['division']]);
            fputcsv($fp, ['عصری تعلیم', $data['asri_taleem']]);
            fputcsv($fp, ['تاریخ', date('d/m/Y')]);
            
            fclose($fp);
            
            return $csv_file;
        }
        
        // Call function
        createStudentCSV($student_id, $student_folder, $_POST);
        
        // ============================================
        // STEP 7: MAIN CSV FILE MEIN SAVE KARO (UPDATED)
        // ============================================
        saveToCSV($student_id, $_POST, $photo_path, $id_card_path, $cert_path);
        
        // ============================================
        // STEP 8: REDIRECT TO DOWNLOAD PAGE
        // ============================================
        header("Location: download.php?id=" . $student_id);
        exit();
        
    } else {
        die("Form submit nahi hua. Dobara try karein. Error: " . $stmt->error);
    }
    
    $stmt->close();
}

// ============================================
// FUNCTION TO SAVE DATA TO MAIN CSV (UPDATED)
// ============================================
function saveToCSV($student_id, $data, $photo, $idcard, $cert) {
    
    $csv_file = "admissions_data.csv";
    $file_exists = file_exists($csv_file);
    
    $fp = fopen($csv_file, 'a');
    if (!$fp) {
        return;
    }
    
    if (!$file_exists) {
        $headers = array(
            'Student ID', 'Submission Date', 'Student Name', 'Father Name', 
            'Permanent Address', 'Current Address', 'Guardian Name', 'Phone',
            'Email', 'Course Applied', 'Photo Path', 'ID Card Path', 'Certificate Path',
            'Date of Birth', 'District', 'Registration Number', 'Madrassa Name',
            'Guardian Phone', 'Previous Madrassa', 'Previous Class', 'Wafaq Rollno',
            'Obtained Marks', 'Percentage', 'Modern Education'
        );
        fputcsv($fp, $headers);
    }
    
    // YAHAN CHANGE: SR- format mein Student ID
    $student_id_formatted = "SR-" . $student_id;
    
    $row = array(
        $student_id_formatted,  // پہلے صرف number tha, ab SR- lagayega
        date('Y-m-d H:i:s'),
        $data['student_name'],
        $data['father_name'],
        $data['permanent_address'],
        $data['current_address'],
        $data['guardian_name'],
        $data['phone'],
        $data['email'],
        $data['course_applied'],
        $photo,
        $idcard,
        $cert,
        $data['dob'] ?? '',
        $data['district'] ?? '',
        $data['registration_number'] ?? '',
        $data['madrassa_name'] ?? '',
        $data['guardian_phone'] ?? '',
        $data['previous_madrassa_name'] ?? '',
        $data['previous_class'] ?? '',
        $data['wafaq_rollno'] ?? '',
        $data['obtained_marks'] ?? '',
        $data['percentage'] ?? '',
        $data['modern_education'] ?? ''
    );
    
    fputcsv($fp, $row);
    fclose($fp);
    @chmod($csv_file, 0644);
}

$conn->close();
?>