<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
$student_id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

define('DB_HOST', 'localhost');
define('DB_USER', 'daruwubs_madrassa_db');
define('DB_PASS', 'Khan(1234)@');
define('DB_NAME', 'daruwubs_admission.php');

$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
if ($conn->connect_error) {
    die("Connection failed");
} else {
    $conn->set_charset("utf8mb4");
    $student = null;
    if ($student_id > 0) {
        $stmt = $conn->prepare("SELECT * FROM students WHERE id = ?");
        $stmt->bind_param("i", $student_id);
        $stmt->execute();
        $result = $stmt->get_result();
        $student = $result->fetch_assoc();
        $stmt->close();
    }
    $conn->close();
}
?>
<!DOCTYPE html>
<html lang="ur" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>جامعہ دارالعلوم حقانیہ - داخلہ فارم</title>
    
    <!-- Google Fonts - Sirf Noto Naskh Arabic -->
    <link href="https://fonts.googleapis.com/css2?family=Noto+Naskh+Arabic:wght@400;500;600;700&display=swap" rel="stylesheet">
    
    <!-- Font Awesome for icons -->
    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.15.4/css/all.css">
    
    <!-- html2pdf library -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/html2pdf.js/0.10.1/html2pdf.bundle.min.js"></script>
    
    <style>
        * { 
            box-sizing: border-box; 
            color: black !important;
            font-family: 'Noto Naskh Arabic', 'Arial', sans-serif !important;
        }
        
        body {
            background-color: #333;
            margin: 0; 
            padding: 0;
            display: flex; 
            flex-direction: column; 
            align-items: center;
        }

        /* EXACT A4 SIZE */
        #form-content {
            background-color: #fff;
            width: 794px;
            height: 1123px;
            padding: 20px 30px;
            border: 1px solid #000;
            position: relative;
            color: #000 !important;
            overflow: hidden;
            font-size: 13px;
            line-height: 1.4;
            direction: rtl;  /* یہ ADD کرو */
    text-align: right;  /* یہ ADD کرو */
        }

        .header-table { width: 100%; border-collapse: collapse; margin-bottom: 5px; }
        .photo-box { width: 90px; height: 115px; border: 1.5px solid #000; text-align: center; }
        .photo-box img { width: 100%; height: 100%; object-fit: cover; }
        
        .logo-circle { width: 75px; height: 75px; border: 1.5px solid #000; border-radius: 50%; margin: 0 auto; display: flex; align-items: center; justify-content: center; font-size: 0.6rem; }

        .bismillah { font-size: 0.9rem; font-weight: bold; margin-bottom: 10px; }
        .form-badge { background: #000; color: white !important; padding: 2px 25px; border-radius: 50px; font-weight: bold; font-size: 1rem; }
        .institute-name { font-size: 1.8rem; font-weight: 700; margin: 5px 0 0; }
        .district-text { font-size: 1rem; font-weight: bold; margin-bottom: 10px; }

        .row {
            display: flex;
            margin-bottom: 8px;
            gap: 10px;
            width: 100%;
        }

        .label {
            font-weight: normal;
            white-space: nowrap;
            font-size: 0.9rem;
        }

        .dots {
            border-bottom: 1px dotted #000;
            flex-grow: 1;
            height: 25px;
            position: relative;
            margin: 0 3px;
        }

        .val {
            .val {
    position: absolute;
    left: 3px;  /* right ki jagah left */
    top: 2px;
    background: white;
    padding: 0 3px;
    font-size: 13px;
}
        
            top: 2px;
            background: white;
            padding: 0 3px;
            font-size: 13px;
        }

        .declaration { 
            text-align: justify; 
            font-size: 0.9rem; 
            line-height: 1.5; 
            margin: 8px 0; 
        }

        .section-badge { 
            background: #000; 
            color: white !important; 
            padding: 1px 15px; 
            border-radius: 10px; 
            font-weight: bold; 
            font-size: 0.85rem; 
            display: inline-block;
            margin: 3px 0;
        }

        .notice-box { 
            background-color: #f0f0f0; 
            border: 1.5px solid #000; 
            border-radius: 30px; 
            padding: 3px; 
            text-align: center; 
            font-weight: bold; 
            font-size: 0.8rem; 
            margin: 8px 0; 
        }

        .footer-table { 
            width: 100%; 
            border-collapse: collapse; 
            margin-top: 15px; 
            border: 1.5px solid #000; 
        }
        .office-box { 
            border: 1.5px solid #000; 
            width: 25%; 
            height: 100px; 
            vertical-align: top; 
            padding: 5px; 
            font-size: 0.7rem; 
        }
        .stamp-oval { 
            border: 2.5px solid #000; 
            border-radius: 50%; 
            width: 130px; 
            height: 75px; 
            margin: 0 auto; 
            display: flex; 
            align-items: center; 
            justify-content: center; 
            font-weight: bold; 
            font-size: 1.1rem; 
        }

        .controls { 
            background: #fff; 
            padding: 15px; 
            margin: 10px; 
            width: 794px; 
            text-align: center; 
            border-radius: 10px; 
        }
        .btn-dl { 
            background: #1a472a; 
            color: white !important; 
            padding: 10px 30px; 
            border: none; 
            border-radius: 5px; 
            cursor: pointer; 
            font-weight: bold; 
        }

        @media print { 
            .controls { display: none; } 
            body { background: #fff; } 
            #form-content { border: none; } 
        }
    </style>
</head>
<body>

<div class="controls">
    <button class="btn-dl" onclick="generatePDF()">فارم ڈاؤن لوڈ کریں</button>
</div>

<div id="form-content">
    <table class="header-table">
        <tr>
            <td style="width: 120px;">
                <div class="photo-box">
                    <?php if(isset($student['photo_path']) && file_exists($student['photo_path'])): ?>
                        <img src="<?= $student['photo_path'] ?>">
                    <?php else: ?>
                        تصویر
                    <?php endif; ?>
                </div>
            </td>
            <td style="text-align: center;">
                <div class="bismillah">بسم اللہ الرحمن الرحیم</div>
                <div class="form-badge">داخلہ فارم</div>
                <div class="institute-name">جامعہ دارالعلوم حقانیہ</div>
                <div class="district-text">اکوڑہ خٹک ضلع نوشہرہ</div>
            </td>
            <td style="width: 120px; text-align: left;">
                <div class="logo-circle">
                    <img src="images/logo.png" alt="جامعہ حقانیہ" style="width:100%; height:100%; border-radius:50%; object-fit:cover;">
                </div>
            </td>
        </tr>
    </table>

    <div class="row">

        <div style="flex:1; display:flex;"><span class="label">مطلوبہ درجہ</span><div class="dots"><span class="val"><?= $student['course_applied'] ?? '' ?></span></div></div>

        <div style="flex:1; display:flex;"><span class="label">سیریل نمبر</span><div class="dots"><span class="val"><?= $student['id'] ?? '' ?></span></div></div>

    </div>
    
    

    <div class="declaration">

    بخدمت جناب اقدس حضرت مہتمم صاحب! السلام علیکم!<br>

    اما بعد خدمت عالیہ میں داخلہ کی استدعا کرتے ہوئے اقرار کرتا ہوں کہ تا قیام جامعہ کے جملہ قوانین کا پابند رہوں گا اور پوری دلجمعی سے تحصیل علم دین میں مشغول رہوں گا۔

</div>

<div class="row">
    <div style="flex:1; display:flex;">
        <span class="label">تاریخ</span>
        <div class="dots">
            <span class="val"><?= date('d/m/Y') ?></span>
        </div>
    </div>
</div>

<div style="text-align:center;">
    <div class="section-badge">تعارف</div>
</div>

<!-- نام + ولدیت + شناختی کارڈ ایک لائن میں -->
<div class="row" style="display: flex; gap: 15px; margin-bottom: 15px;">
    <div style="flex: 1; display: flex; align-items: center;">
        <span class="label" style="min-width: 40px;">نام</span>
        <div class="dots"><span class="val"><?= $student['student_name'] ?? '' ?></span></div>
    </div>
    
    <div style="flex: 1; display: flex; align-items: center;">
        <span class="label" style="min-width: 50px;">ولدیت</span>
        <div class="dots"><span class="val"><?= $student['father_name'] ?? '' ?></span></div>
    </div>
    
    <div style="flex: 1; display: flex; align-items: center;">
        <span class="label" style="min-width: 60px;">شناختی کارڈ نمبر
</span>
        <div class="dots"><span class="val"><?= $student['cnic_number'] ?? '' ?></span></div>
    </div>
</div>

<div class="row">
    <div style="flex:1; display:flex;">
        <span class="label">تاریخ پیدائش</span>
        <div class="dots"><span class="val"><?= $student['dob'] ?? '' ?></span></div>
    </div>
    <div style="flex:1; display:flex;">
        <span class="label">موبائل</span>
        <div class="dots"><span class="val"><?= $student['phone'] ?? '' ?></span></div>
    </div>
    <div style="flex:0.7; display:flex;">
        <span class="label">ضلع</span>
        <div class="dots"><span class="val"><?= $student['district'] ?? '' ?></span></div>
    </div>
</div>

<div class="row">
    <div style="flex:1; display:flex;">
        <span class="label">سرپرست</span>
        <div class="dots"><span class="val"><?= $student['guardian_name'] ?? '' ?></span></div>
    </div>
    <div style="flex:1; display:flex;">
        <span class="label">سرپرست کا موبائل</span>
        <div class="dots"><span class="val"><?= $student['guardian_phone'] ?? '' ?></span></div>
    </div>
</div>

<div class="row">
    <div style="flex:1; display:flex;">
        <span class="label">مستقل پتہ</span>
        <div class="dots"><span class="val"><?= $student['permanent_address'] ?? '' ?></span></div>
    </div>
</div>

<div class="row">
    <div style="flex:1; display:flex;">
        <span class="label">موجودہ پتہ</span>
        <div class="dots"><span class="val"><?= $student['current_address'] ?? '' ?></span></div>
    </div>
</div>

<div class="row">
    <div style="flex:1; display:flex;">
        <span class="label">ملک</span>
        <div class="dots"><span class="val"><?= $student['country'] ?? '' ?></span></div>
    </div>
</div>


<div style="text-align:center;">
    <div class="section-badge">تعلیمی کیفیت</div>
</div>

<div class="row">
    <div style="flex:1; display:flex;">
     <span class="label">سابقہ مدرسہ</span>
        <div class="dots"><span class="val"><?= $student['previous_madrasa_address'] ?? '' ?></span></div>
    </div>
</div>

<div class="row">
    <div style="flex:1; display:flex;">
        <span class="label">سابقہ وفاقی درجہ</span>
        <div class="dots"><span class="val"><?= $student['previous_class'] ?? '' ?></span></div>
    </div>
    <div style="flex:1; display:flex;">
        <span class="label">وفاق کا رول نمبر</span>
        <div class="dots"><span class="val"><?= $student['wifaq_roll_no'] ?? '' ?></span></div>
    </div>
</div>

<div class="row">
    <div style="flex:1; display:flex;">
        <span class="label">حاصل کردہ نمبرات</span>
        <div class="dots"><span class="val"><?= $student['obtained_marks'] ?? '' ?></span></div>
    </div>
    <div style="flex:1; display:flex;">
        <span class="label">تقدیر</span>
        <div class="dots"><span class="val"><?= $student['division'] ?? '' ?></span></div>
    </div>
</div>

<div class="row">
    <div style="flex:1; display:flex;">
        <span class="label">عصری تعلیم</span>
        <div class="dots"><span class="val"><?= $student['asri_taleem'] ?? '' ?></span></div>
    </div>
    <div style="flex:1.5; display:flex;">
        <span class="label">دستخط طالب علم</span>
        <div class="dots"></div>
    </div>
</div>

<div class="notice-box">
    نوٹ: فارم صاف ستھرا پُر کریں۔ سابقہ وفاقی درجہ کی سند / کشفُ الدرجات اور شناختی کارڈ کی نقل منسلک کریں۔
</div>

<div style="text-align:center; margin-bottom:8px; margin-top:5px;">
    <div style="background:#000; color:#ffffff !important; padding:3px 25px; border-radius:20px; font-weight:bold; font-size:16px; display:inline-block;">
        دفتری کارروائی
    </div>
</div>

<table class="footer-table">
<tr>
<td class="office-box">
    <strong>مراسلات ممتحن</strong>
    <div style="margin-top:5px;">
        <div style="display:flex;"><span>دستخط</span><span style="flex:1; border-bottom:1px solid #000;"></span></div>
        <div style="display:flex; margin-top:3px;"><span>تاریخ</span><span style="flex:1; border-bottom:1px solid #000;"></span></div>
    </div>
</td>

<td class="office-box">
    <strong>مراسلات مالیات</strong>
    <div style="margin-top:5px;">
        <div style="display:flex;"><span>دستخط</span><span style="flex:1; border-bottom:1px solid #000;"></span></div>
        <div style="display:flex; margin-top:3px;"><span>تاریخ</span><span style="flex:1; border-bottom:1px solid #000;"></span></div>
    </div>
</td>

<td class="office-box">
    <strong>مراسلات تعلیمات</strong>
    <div style="margin-top:5px;">
        <div style="display:flex;"><span>دستخط</span><span style="flex:1; border-bottom:1px solid #000;"></span></div>
        <div style="display:flex; margin-top:3px;"><span>تاریخ</span><span style="flex:1; border-bottom:1px solid #000;"></span></div>
    </div>
</td>
</tr>
</table>

<div style="margin-top:20px; padding:8px; text-align:center; font-weight:bold;">
    یہ فارم پرنٹ کر کے مقررہ تاریخ کو جامعہ حقانیہ کے دفترِ تعلیمات میں جمع کروائیں۔
</div>

<script>
    function generatePDF() {
        setTimeout(function() {
            const element = document.getElementById('form-content');
            
            const opt = {
                margin: [0, 0, 0, 0],
                filename: 'Admission_Form_<?= $student_id ?>.pdf',
                image: { type: 'jpeg', quality: 1 },
                html2canvas: { 
                    scale: 2,
                    useCORS: true,
                    logging: true,
                    allowTaint: false,
                    backgroundColor: '#ffffff',
                    letterRendering: true
                     
                },
                jsPDF: { 
                    unit: 'px', 
                    format: [794, 1123], 
                    orientation: 'portrait'
                }
            };
            
            html2pdf().from(element).set(opt).save();
        }, 1000);
    }
    
    window.onload = function() { 
        generatePDF();
    };
</script>

</body>
</html>