<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

define('DB_HOST', 'localhost');
define('DB_USER', 'daruwubs_madrassa_db');
define('DB_PASS', 'Khan(1234)@');
define('DB_NAME', 'daruwubs_admission.php');

$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}
$conn->set_charset("utf8mb4");

if (isset($_POST['download'])) {
    $name = trim($_POST['student_name']);
    $father = trim($_POST['father_name']);
    $phone = trim($_POST['phone']);
    
    $phone_clean = preg_replace('/[^0-9]/', '', $phone);
    $name_no_spaces = str_replace(' ', '', $name);
    $father_no_spaces = str_replace(' ', '', $father);
    
    $query = $conn->query("
        SELECT * FROM students 
        WHERE REPLACE(phone, '-', '') LIKE '%$phone_clean%'
    ");
    
    if ($query && $query->num_rows > 0) {
        $students = [];
        while($row = $query->fetch_assoc()) {
            $students[] = $row;
        }
        
        if (count($students) == 1) {
            header("Location: print_form.php?id=" . $students[0]['id']);
            exit();
        } else {
            foreach($students as $student) {
                $db_name = str_replace(' ', '', trim($student['student_name']));
                $db_father = str_replace(' ', '', trim($student['father_name']));
                
                if (strpos($db_name, $name_no_spaces) !== false && strpos($db_father, $father_no_spaces) !== false) {
                    header("Location: print_form.php?id=" . $student['id']);
                    exit();
                }
            }
            $error = "❌ ریکارڈ نہیں ملا";
        }
    } else {
        $error = "❌ ریکارڈ نہیں ملا";
    }
}
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>جامعہ دارالعلوم حقانیہ - فارم ڈاؤن لوڈ</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap');
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Inter', sans-serif;
            background: linear-gradient(145deg, #f8fafc 0%, #eef2f6 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 16px;
        }
        
        .card {
            max-width: 440px;  /* پہلے 480 تھا - چھوٹا کیا */
            width: 100%;
            background: white;
            border-radius: 28px;  /* 32 سے 28 */
            box-shadow: 0 20px 40px -12px rgba(0, 0, 0, 0.2);
            overflow: hidden;
            position: relative;
        }
        
        .card-header {
            background: linear-gradient(145deg, #0a4b33, #1a5a3a);
            padding: 24px 20px;  /* 32 سے 24 */
            text-align: center;
            position: relative;
            overflow: hidden;
        }
        
        .card-header::before {
            content: '';
            position: absolute;
            top: -50%;
            left: -50%;
            width: 200%;
            height: 200%;
            background: linear-gradient(45deg, transparent 30%, rgba(212, 175, 55, 0.1) 50%, transparent 70%);
            animation: shine 8s infinite;
        }
        
        @keyframes shine {
            0% { transform: translateX(-100%) translateY(-100%) rotate(45deg); }
            100% { transform: translateX(100%) translateY(100%) rotate(45deg); }
        }
        
        .mosque-icon {
            width: 64px;  /* 72 سے 64 */
            height: 64px; /* 72 سے 64 */
            background: rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(8px);
            border-radius: 20px; /* 24 سے 20 */
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 12px; /* 16 سے 12 */
            border: 1px solid rgba(212, 175, 55, 0.3);
        }
        
        .mosque-icon i {
            font-size: 32px; /* 36 سے 32 */
            color: #d4af37;
        }
        
        .card-header h1 {
            color: white;
            font-size: 18px; /* 20 سے 18 */
            font-weight: 600;
            letter-spacing: 0.5px;
            margin-bottom: 4px;
        }
        
        .card-header p {
            color: #d4af37;
            font-size: 13px; /* 14 سے 13 */
            font-weight: 500;
        }
        
        .card-body {
            padding: 24px 20px; /* 32 سے 24 */
            direction: rtl; /* اردو کے لیے دائیں سے بائیں */
        }
        
        .title {
            text-align: center;
            margin-bottom: 20px; /* 28 سے 20 */
        }
        
        .title h2 {
            color: #0a4b33;
            font-size: 20px; /* 22 سے 20 */
            font-weight: 700;
            margin-bottom: 6px; /* 8 سے 6 */
        }
        
        .title p {
            color: #64748b;
            font-size: 13px; /* 14 سے 13 */
        }
        
        .form-group {
            margin-bottom: 16px; /* 20 سے 16 */
        }
        
        .form-group label {
            display: block;
            color: #0a4b33;
            font-size: 13px; /* 14 سے 13 */
            font-weight: 600;
            margin-bottom: 4px; /* 6 سے 4 */
            text-align: right; /* دائیں طرف */
            padding-right: 8px;
        }
        
        .input-wrapper {
            position: relative;
            display: flex;
            align-items: center;
        }
        
        .input-icon {
            position: absolute;
            left: 12px; /* right کی جگہ left */
            right: auto;
            color: #94a3b8;
            font-size: 16px; /* 18 سے 16 */
        }
        
        input {
            width: 100%;
            padding: 10px 16px 10px 36px; /* اونچائی کم - 14px سے 10px */
            border: 2px solid #e2e8f0;
            border-radius: 12px; /* 16 سے 12 */
            font-size: 14px; /* 15 سے 14 */
            font-family: 'Inter', sans-serif;
            transition: all 0.2s ease;
            background: #f8fafc;
            text-align: right; /* ٹیکسٹ دائیں طرف */
        }
        
        input:focus {
            border-color: #d4af37;
            outline: none;
            background: white;
            box-shadow: 0 4px 10px rgba(212, 175, 55, 0.15);
        }
        
        input::placeholder {
            color: #94a3b8;
            font-size: 13px; /* 14 سے 13 */
            text-align: right;
        }
        
        .btn-download {
            width: 100%;
            background: linear-gradient(145deg, #0a4b33, #1a5a3a);
            color: white;
            border: none;
            padding: 14px; /* 16 سے 14 */
            border-radius: 40px; /* 100px سے 40 */
            font-size: 15px; /* 16 سے 15 */
            font-weight: 600;
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px; /* 12 سے 10 */
            transition: all 0.2s ease;
            margin-top: 20px; /* 24 سے 20 */
            border: 1px solid rgba(212, 175, 55, 0.3);
        }
        
        .btn-download:hover {
            background: #1a5a3a;
            transform: translateY(-2px);
            box-shadow: 0 15px 25px -10px rgba(10, 75, 51, 0.3);
        }
        
        .btn-download i {
            font-size: 16px; /* 18 سے 16 */
            color: #d4af37;
        }
        
        .loading {
            display: none;
            text-align: center;
            margin-top: 16px; /* 20 سے 16 */
            padding: 12px; /* 16 سے 12 */
            background: #f8fafc;
            border-radius: 14px; /* 16 سے 14 */
        }
        
        .spinner {
            display: inline-block;
            width: 36px; /* 40 سے 36 */
            height: 36px; /* 40 سے 36 */
            border: 3px solid #e2e8f0;
            border-top-color: #d4af37;
            border-radius: 50%;
            animation: spin 0.8s linear infinite;
            margin-bottom: 6px; /* 8 سے 6 */
        }
        
        @keyframes spin {
            to { transform: rotate(360deg); }
        }
        
        .loading p {
            color: #0a4b33;
            font-size: 13px; /* 14 سے 13 */
            font-weight: 500;
        }
        
        .error {
            background: #fee2e2;
            border: 1px solid #ef4444;
            border-radius: 14px; /* 16 سے 14 */
            padding: 12px; /* 16 سے 12 */
            margin-bottom: 16px; /* 20 سے 16 */
            display: flex;
            align-items: center;
            gap: 10px; /* 12 سے 10 */
        }
        
        .error i {
            color: #ef4444;
            font-size: 18px; /* 20 سے 18 */
        }
        
        .error p {
            color: #b91c1c;
            font-size: 13px; /* 14 سے 13 */
            font-weight: 500;
        }
        
        .footer-note {
            text-align: center;
            margin-top: 18px; /* 24 سے 18 */
            padding-top: 12px; /* 16 سے 12 */
            border-top: 2px dashed #e2e8f0;
        }
        
        .footer-note p {
            color: #64748b;
            font-size: 12px; /* 13 سے 12 */
        }
        
        .footer-note i {
            color: #d4af37;
            font-size: 11px; /* 12 سے 11 */
            margin: 0 3px; /* 4 سے 3 */
        }
    </style>
</head>
<body>
    <div class="card">
        <div class="card-header">
            <div class="mosque-icon">
                <i class="fas fa-mosque"></i>
            </div>
            <h1>جامعہ دارالعلوم حقانیہ</h1>
            <p>اکوڑہ خٹک - تعلیمی سال 2026</p>
        </div>
        
        <div class="card-body">
            <div class="title">
                <h2>📥 فارم ڈاؤن لوڈ</h2>
                <p>اپنا نام، والد کا نام اور موبائل نمبر درج کریں</p>
            </div>
            
            <?php if (isset($error)): ?>
                <div class="error">
                    <i class="fas fa-exclamation-circle"></i>
                    <p><?php echo $error; ?></p>
                </div>
            <?php endif; ?>
            
            <form method="post" id="downloadForm">
                <div class="form-group">
                    <label>
                        <i class="fas fa-user" style="color: #d4af37; margin-left: 5px;"></i>
                        اپنا نام
                    </label>
                    <div class="input-wrapper">
                        <input type="text" name="student_name" required placeholder="عبداللہ">
                        <i class="fas fa-pen input-icon"></i>
                    </div>
                </div>
                
                <div class="form-group">
                    <label>
                        <i class="fas fa-user-tie" style="color: #d4af37; margin-left: 5px;"></i>
                        والد کا نام
                    </label>
                    <div class="input-wrapper">
                        <input type="text" name="father_name" required placeholder="محمد">
                        <i class="fas fa-pen input-icon"></i>
                    </div>
                </div>
                
                <div class="form-group">
                    <label>
                        <i class="fas fa-phone" style="color: #d4af37; margin-left: 5px;"></i>
                        موبائل نمبر
                    </label>
                    <div class="input-wrapper">
                        <input type="tel" name="phone" required placeholder="03XX-XXXXXXX">
                        <i class="fas fa-mobile-alt input-icon"></i>
                    </div>
                </div>
                
                <button type="submit" name="download" class="btn-download" onclick="showLoading()">
                    <i class="fas fa-download"></i>
                    فارم ڈاؤن لوڈ کریں
                </button>
            </form>
            
            <div id="loading" class="loading">
                <div class="spinner"></div>
                <p>براہ کرم انتظار کریں... فارم تیار ہو رہا ہے</p>
            </div>
            
            <div class="footer-note">
                <p>
                    <i class="fas fa-circle-info"></i>
                    موبائل نمبر وہی درج کریں جو فارم بھرتے وقت دیا تھا
                    <i class="fas fa-circle-info"></i>
                </p>
            </div>
        </div>
    </div>
    
    <script>
    function showLoading() {
        document.getElementById('loading').style.display = 'block';
        return true;
    }
    </script>
</body>
</html>
<?php $conn->close(); ?>