<!DOCTYPE html>
<html lang="ur" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>جامعہ دارالعلوم حقانیہ - آن لائن داخلہ پورٹل</title>
    
    <!-- Font Awesome 5 (stable version) -->
    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.15.4/css/all.css">
    
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Noto+Naskh+Arabic:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Noto+Nastaliq+Urdu:wght@400;700&display=swap" rel="stylesheet">
    
    <!-- Extra fallback for icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <style>
    /* Force icons to show */
.fas, .far, .fab, .fa {
    font-family: 'Font Awesome 5 Free', 'Font Awesome 5 Brands', 'Font Awesome 6 Free' !important;
    font-weight: 900 !important;
}
        :root {
            --primary: #1a472a;
            --primary-dark: #0d2416;
            --primary-light: #2e8b57;
            --secondary: #d4af37;
            --light: #f8f9fa;
            --dark: #212529;
            --border: #dee2e6;
            --shadow: 0 4px 6px rgba(0,0,0,0.1);
            --shadow-hover: 0 15px 30px rgba(0,0,0,0.15);
            --radius: 8px;
            --transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body.urdu {
            font-family: 'Noto Naskh Arabic', serif;
            direction: rtl;
        }
        
        body.english {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            direction: ltr;
        }
        
        body {
            background: linear-gradient(135deg, #f5f7fa 0%, #e4edf5 100%);
            color: #333;
            line-height: 1.5;
            transition: var(--transition);
            font-size: 14px;  /* MAIN FONT SIZE - CHHOTA */
        }
        
        /* Animations */
        @keyframes slideDown {
            from { opacity: 0; transform: translateY(-30px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        @keyframes fadeInUp {
            from { opacity: 0; transform: translateY(30px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        @keyframes fadeInLeft {
            from { opacity: 0; transform: translateX(-30px); }
            to { opacity: 1; transform: translateX(0); }
        }
        
        @keyframes fadeInRight {
            from { opacity: 0; transform: translateX(30px); }
            to { opacity: 1; transform: translateX(0); }
        }
        
        @keyframes scaleIn {
            from { opacity: 0; transform: scale(0.9); }
            to { opacity: 1; transform: scale(1); }
        }
        
        @keyframes pulse {
            0% { transform: scale(1); }
            50% { transform: scale(1.05); }
            100% { transform: scale(1); }
        }
        
        @keyframes float {
            0% { transform: translateY(0px); }
            50% { transform: translateY(-10px); }
            100% { transform: translateY(0px); }
        }
        
        .animated {
            animation: slideDown 0.6s ease-out;
        }
        
        .fade-up {
            animation: fadeInUp 0.8s ease-out;
        }
        
        .fade-left {
            animation: fadeInLeft 0.8s ease-out;
        }
        
        .fade-right {
            animation: fadeInRight 0.8s ease-out;
        }
        
        .scale-in {
            animation: scaleIn 0.6s ease-out;
        }
        
        .float {
            animation: float 3s ease-in-out infinite;
        }
        
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 20px;
        }
        
        /* Language Switcher */
        .lang-switcher {
            position: fixed;
            top: 20px;
            left: 20px;
            z-index: 1001;
            background: white;
            padding: 5px;
            border-radius: 50px;
            box-shadow: var(--shadow);
            animation: slideDown 0.6s ease-out;
        }
        
        .lang-btn {
            padding: 6px 16px;  /* CHHOTA */
            border: none;
            border-radius: 50px;
            cursor: pointer;
            font-weight: 600;
            transition: var(--transition);
            background: transparent;
            font-size: 13px;  /* CHHOTA */
        }
        
        .lang-btn.active {
            background: var(--primary);
            color: white;
        }
        
        .lang-btn:hover {
            transform: translateY(-2px);
            box-shadow: var(--shadow);
        }
        
        /* Header */
        .main-header {
            background: linear-gradient(135deg, var(--primary) 0%, var(--primary-dark) 100%);
            color: white;
            padding: 25px 0;  /* CHHOTA */
            box-shadow: var(--shadow);
            position: relative;
            overflow: hidden;
            animation: slideDown 0.6s ease-out;
        }
        
        .main-header::before {
            content: '';
            position: absolute;
            top: -50%;
            left: -50%;
            width: 200%;
            height: 200%;
            background: radial-gradient(circle, rgba(255,255,255,0.1) 0%, transparent 70%);
            animation: pulse 10s infinite linear;
        }
        
        .header-content {
            position: relative;
            z-index: 1;
            text-align: center;
        }
        
        .institute-logo {
            display: flex;
            justify-content: center;
            align-items: center;
            gap: 20px;  /* CHHOTA */
            margin-bottom: 15px;  /* CHHOTA */
        }
        
        .logo-icon {
            font-size: 3rem;  /* CHHOTA */
            color: var(--secondary);
            animation: float 3s ease-in-out infinite;
        }
        
        .institute-name h1 {
            font-size: 2rem;  /* CHHOTA - pehle 2.5rem */
            margin-bottom: 8px;  /* CHHOTA */
        }
        
        .institute-subtitle {
            font-size: 1rem;  /* CHHOTA - pehle 1.2rem */
            margin-bottom: 12px;  /* CHHOTA */
            opacity: 0.9;
        }
        
        .academic-year {
            display: inline-block;
            background: rgba(212, 175, 55, 0.25);
            padding: 8px 20px;  /* CHHOTA */
            border-radius: 50px;
            border: 2px solid rgba(212, 175, 55, 0.4);
            backdrop-filter: blur(5px);
            font-size: 0.9rem;  /* CHHOTA */
        }
        
        /* Mobile Navigation Toggle */
        .nav-toggle {
            display: none;
            font-size: 1.5rem;  /* CHHOTA */
            cursor: pointer;
            color: var(--primary);
            padding: 8px;  /* CHHOTA */
            transition: var(--transition);
        }
        
        .nav-toggle:hover {
            color: var(--primary-light);
            transform: scale(1.1);
        }
        
        /* Navigation */
        .main-nav {
            background: white;
            box-shadow: var(--shadow);
            position: sticky;
            top: 0;
            z-index: 1000;
            animation: slideDown 0.8s ease-out;
        }
        
        .nav-container {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 10px 0;  /* CHHOTA */
        }
        
        .nav-links {
            display: flex;
            gap: 20px;  /* CHHOTA */
            list-style: none;
            transition: var(--transition);
        }
        
        .nav-links a {
            color: var(--primary);
            text-decoration: none;
            font-weight: 600;
            padding: 8px 15px;  /* CHHOTA */
            border-radius: var(--radius);
            transition: var(--transition);
            display: flex;
            align-items: center;
            gap: 6px;  /* CHHOTA */
            position: relative;
            overflow: hidden;
            font-size: 0.9rem;  /* CHHOTA */
        }
        
        .nav-links a::before {
            content: '';
            position: absolute;
            bottom: 0;
            left: 50%;
            width: 0;
            height: 2px;
            background: var(--secondary);
            transition: var(--transition);
            transform: translateX(-50%);
        }
        
        .nav-links a:hover::before,
        .nav-links a.active::before {
            width: 80%;
        }
        
        .nav-links a:hover,
        .nav-links a.active {
            background: var(--primary);
            color: white;
            transform: translateY(-2px);
            box-shadow: var(--shadow);
        }
        
        /* Hero Section */
        .hero-section {
            padding: 60px 0;  /* CHHOTA */
            background: linear-gradient(rgba(26, 71, 42, 0.85), rgba(26, 71, 42, 0.85)), 
                        url('https://images.unsplash.com/photo-1589998059171-988d887df646?auto=format&fit=crop&w=1350&q=80');
            background-size: cover;
            background-attachment: fixed;
            color: white;
            text-align: center;
            position: relative;
            overflow: hidden;
        }
        
        .hero-section::after {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: linear-gradient(45deg, transparent 30%, rgba(212, 175, 55, 0.1) 100%);
            animation: pulse 4s ease-in-out infinite;
        }
        
        .hero-content {
            position: relative;
            z-index: 2;
        }
        
        .hero-content h2 {
            font-size: 2.2rem;  /* CHHOTA - pehle 3.2rem */
            margin-bottom: 15px;  /* CHHOTA */
            animation: fadeInUp 1s ease-out;
            text-shadow: 2px 2px 4px rgba(0,0,0,0.3);
        }
        
        .hero-content p {
            font-size: 1rem;  /* CHHOTA - pehle 1.3rem */
            max-width: 700px;  /* CHHOTA */
            margin: 0 auto 20px;  /* CHHOTA */
            animation: fadeInUp 1s ease-out 0.2s both;
            opacity: 0.95;
        }
        
        .hero-buttons {
            display: flex;
            gap: 15px;  /* CHHOTA */
            justify-content: center;
            animation: fadeInUp 1s ease-out 0.4s both;
        }
        
        .hero-buttons .btn {
            transform-origin: center;
            transition: var(--transition);
        }
        
        .hero-buttons .btn:hover {
            transform: translateY(-5px) scale(1.05);
            box-shadow: 0 20px 30px rgba(0,0,0,0.3);
        }
        
        .btn {
            padding: 10px 25px;  /* CHHOTA - pehle 15px 40px */
            border-radius: 50px;
            text-decoration: none;
            font-weight: 600;
            display: inline-flex;
            align-items: center;
            gap: 8px;  /* CHHOTA */
            border: none;
            cursor: pointer;
            transition: var(--transition);
            position: relative;
            overflow: hidden;
            font-size: 0.95rem;  /* CHHOTA */
        }
        
        .btn::after {
            content: '';
            position: absolute;
            top: 50%;
            left: 50%;
            width: 0;
            height: 0;
            border-radius: 50%;
            background: rgba(255,255,255,0.3);
            transform: translate(-50%, -50%);
            transition: width 0.6s, height 0.6s;
        }
        
        .btn:hover::after {
            width: 300px;
            height: 300px;
        }
        
        .btn-primary {
            background: var(--secondary);
            color: var(--dark);
        }
        
        .btn-secondary {
            background: transparent;
            color: white;
            border: 2px solid white;
        }
        
        .btn-secondary:hover {
            background: white;
            color: var(--primary);
        }
        
        /* Section Title */
        .section-title {
            text-align: center;
            margin-bottom: 30px;  /* CHHOTA */
            color: var(--primary);
        }
        
        .section-title h2 {
            font-size: 1.8rem;  /* CHHOTA - pehle 2.5rem */
            margin-bottom: 10px;  /* CHHOTA */
            display: inline-block;
            padding-bottom: 8px;  /* CHHOTA */
            border-bottom: 3px solid var(--secondary);  /* CHHOTA */
            position: relative;
        }
        
        .section-title h2::after {
            content: '';
            position: absolute;
            bottom: -3px;  /* CHHOTA */
            left: 50%;
            width: 0;
            height: 3px;  /* CHHOTA */
            background: var(--primary);
            transform: translateX(-50%);
            animation: slideIn 1s ease-out forwards;
        }
        
        .section-title p {
            font-size: 0.95rem;  /* CHHOTA */
        }
        
        @keyframes slideIn {
            to { width: 50%; }
        }
        
        /* Announcements */
        .announcements-section {
            padding: 50px 0;  /* CHHOTA */
            background: var(--light);
        }
        
        .announcements-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));  /* CHHOTA */
            gap: 20px;  /* CHHOTA */
        }
        
        .announcement-card {
            background: white;
            border-radius: var(--radius);
            overflow: hidden;
            box-shadow: var(--shadow);
            border-top: 4px solid var(--primary);  /* CHHOTA */
            transition: var(--transition);
            animation: scaleIn 0.6s ease-out;
            animation-fill-mode: both;
            position: relative;
        }
        
        .announcement-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: linear-gradient(135deg, transparent 0%, rgba(26, 71, 42, 0.05) 100%);
            opacity: 0;
            transition: var(--transition);
        }
        
        .announcement-card:nth-child(1) { animation-delay: 0.1s; }
        .announcement-card:nth-child(2) { animation-delay: 0.2s; }
        .announcement-card:nth-child(3) { animation-delay: 0.3s; }
        
        .announcement-card:hover {
            transform: translateY(-10px) scale(1.02);  /* CHHOTA */
            box-shadow: var(--shadow-hover);
        }
        
        .announcement-card:hover::before {
            opacity: 1;
        }
        
        .announcement-header {
            padding: 15px;  /* CHHOTA */
            background: linear-gradient(135deg, var(--primary-light) 0%, var(--primary) 100%);
            color: white;
            position: relative;
            overflow: hidden;
        }
        
        .announcement-header::after {
            content: '';
            position: absolute;
            top: -50%;
            right: -50%;
            width: 100%;
            height: 200%;
            background: radial-gradient(circle, rgba(255,255,255,0.2) 0%, transparent 70%);
            animation: pulse 6s infinite;
        }
        
        .announcement-header h3 {
            margin-bottom: 4px;  /* CHHOTA */
            font-size: 1.1rem;  /* CHHOTA */
        }
        
        .announcement-header p {
            font-size: 0.8rem;  /* CHHOTA */
            opacity: 0.9;
        }
        
        .announcement-body {
            padding: 15px;  /* CHHOTA */
            position: relative;
            z-index: 2;
        }
        
        .announcement-body ul {
            list-style: none;
        }
        
        .announcement-body li {
            padding: 8px 0;  /* CHHOTA */
            border-bottom: 1px solid var(--border);
            display: flex;
            align-items: center;
            gap: 8px;  /* CHHOTA */
            transition: var(--transition);
            font-size: 0.9rem;  /* CHHOTA */
        }
        
        .announcement-body li:hover {
            transform: translateX(-5px);
            color: var(--primary);
        }
        
        .announcement-body li i {
            color: var(--primary-light);
            font-size: 1rem;  /* CHHOTA */
        }
        
        /* Form Section */
        .form-section {
            padding: 50px 0;  /* CHHOTA */
            background: white;
        }
        
        .form-container {
            background: white;
            border-radius: var(--radius);
            box-shadow: 0 15px 30px rgba(0,0,0,0.1);  /* CHHOTA */
            overflow: hidden;
            margin-top: 20px;  /* CHHOTA */
            animation: fadeInUp 1s ease-out;
            transition: var(--transition);
        }
        
        .form-container:hover {
            box-shadow: 0 20px 40px rgba(0,0,0,0.15);  /* CHHOTA */
        }
        
        .form-header {
            background: linear-gradient(135deg, var(--primary) 0%, var(--primary-dark) 100%);
            color: white;
            padding: 20px 30px;  /* CHHOTA */
            position: relative;
            overflow: hidden;
        }
        
        .form-header::after {
            content: '';
            position: absolute;
            top: -50%;
            left: -50%;
            width: 200%;
            height: 200%;
            background: radial-gradient(circle, rgba(255,255,255,0.1) 0%, transparent 70%);
            animation: pulse 8s infinite;
        }
        
        .form-header h3 {
            font-size: 1.5rem;  /* CHHOTA - pehle 2rem */
            display: flex;
            align-items: center;
            gap: 10px;  /* CHHOTA */
            position: relative;
            z-index: 2;
        }
        
        .form-body {
            padding: 25px;  /* CHHOTA */
        }
        
        .form-row {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));  /* CHHOTA */
            gap: 15px;  /* CHHOTA */
            margin-bottom: 15px;  /* CHHOTA */
        }
        
        .form-group {
            margin-bottom: 10px;  /* CHHOTA */
            animation: fadeInUp 0.6s ease-out;
        }
        
        .form-label {
            display: block;
            margin-bottom: 5px;  /* CHHOTA */
            font-weight: 600;
            color: var(--primary);
            display: flex;
            align-items: center;
            gap: 5px;  /* CHHOTA */
            transition: var(--transition);
            font-size: 0.9rem;  /* CHHOTA */
        }
        
        .form-control {
            width: 100%;
            padding: 10px 14px;  /* CHHOTA */
            border: 2px solid var(--border);
            border-radius: var(--radius);
            font-size: 0.9rem;  /* CHHOTA */
            font-family: inherit;
            transition: var(--transition);
        }
        
        .form-control:focus {
            outline: none;
            border-color: var(--primary-light);
            box-shadow: 0 0 0 3px rgba(46, 139, 87, 0.1);  /* CHHOTA */
            transform: translateY(-2px);
        }
        
        textarea.form-control {
            min-height: 80px;  /* CHHOTA */
            resize: vertical;
        }
        
        select.form-control {
            background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='14' height='14' fill='%231a472a' viewBox='0 0 16 16'%3E%3Cpath d='M7.247 11.14L2.451 5.658C1.885 5.013 2.345 4 3.204 4h9.592a1 1 0 0 1 .753 1.659l-4.796 5.48a1 1 0 0 1-1.506 0z'/%3E%3C/svg%3E");
            background-repeat: no-repeat;
            background-position: left 12px center;  /* CHHOTA */
            padding-left: 35px;  /* CHHOTA */
        }
        
        /* File Upload */
        .file-upload-container {
            margin-top: 5px;
        }
        
        .file-input-wrapper {
            position: relative;
        }
        
        .file-input {
            position: absolute;
            top: 0;
            right: 0;
            width: 100%;
            height: 100%;
            opacity: 0;
            cursor: pointer;
            z-index: 2;
        }
        
        .file-label {
            display: block;
            padding: 10px;  /* CHHOTA */
            background: #f8f9fa;
            border: 2px dashed var(--border);
            border-radius: var(--radius);
            text-align: center;
            color: #666;
            transition: var(--transition);
            font-size: 0.9rem;  /* CHHOTA */
        }
        
        .file-label:hover {
            background: #e9ecef;
            border-color: var(--primary-light);
            transform: translateY(-2px);
            box-shadow: var(--shadow);
        }
        
        .file-info {
            display: block;
            margin-top: 5px;  /* CHHOTA */
            color: #666;
            font-size: 0.8rem;  /* CHHOTA */
        }
        
        /* Declaration Box */
        .declaration-box {
            background: #f8f9fa;
            border: 2px solid var(--primary);
            border-radius: var(--radius);
            padding: 20px;  /* CHHOTA */
            margin: 25px 0;  /* CHHOTA */
            position: relative;
            animation: fadeInUp 1s ease-out;
        }
        
        .declaration-box::before {
            content: '📜';
            position: absolute;
            top: -15px;  /* CHHOTA */
            right: 20px;  /* CHHOTA */
            background: white;
            padding: 0 10px;  /* CHHOTA */
            font-size: 1.5rem;  /* CHHOTA */
            animation: float 3s ease-in-out infinite;
        }
        
        .news-heading {
            font-size: 1.4rem;  /* CHHOTA - pehle 1.8rem */
            color: var(--primary);
            font-weight: bold;
            margin-bottom: 10px;  /* CHHOTA */
        }
        
        .news-text {
            font-size: 1rem;  /* CHHOTA - pehle 1.2rem */
            line-height: 1.6;
        }
        
        /* Notes Section */
        .notes-section {
            background: #fff9e6;
            border: 2px solid #f1c40f;
            border-radius: var(--radius);
            padding: 20px;  /* CHHOTA */
            margin: 25px 0;  /* CHHOTA */
            animation: fadeInUp 1s ease-out;
        }
        
        .notes-header {
            display: flex;
            align-items: center;
            gap: 10px;  /* CHHOTA */
            margin-bottom: 15px;  /* CHHOTA */
            color: #856404;
        }
        
        .notes-header h3 {
            font-size: 1.3rem;  /* CHHOTA - pehle 1.6rem */
        }
        
        .notes-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));  /* CHHOTA */
            gap: 15px;  /* CHHOTA */
        }
        
        .note-item {
            background: white;
            padding: 15px;  /* CHHOTA */
            border-radius: var(--radius);
            border-right: 4px solid var(--primary-light);
            transition: var(--transition);
        }
        
        .note-item:hover {
            transform: translateY(-5px) scale(1.02);
            box-shadow: var(--shadow-hover);
        }
        
        .note-item h4 {
            color: var(--primary);
            margin-bottom: 8px;  /* CHHOTA */
            display: flex;
            align-items: center;
            gap: 6px;  /* CHHOTA */
            font-size: 1rem;  /* CHHOTA - pehle 1.2rem */
        }
        
        .note-item p {
            font-size: 0.9rem;  /* CHHOTA */
        }
        
        /* Footer */
        .main-footer {
            background: linear-gradient(135deg, var(--primary-dark) 0%, #0a1a10 100%);
            color: white;
            padding: 50px 0 20px;  /* CHHOTA */
            margin-top: 30px;  /* CHHOTA */
            position: relative;
            overflow: hidden;
        }
        
        .main-footer::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: radial-gradient(circle at 20% 50%, rgba(212, 175, 55, 0.1) 0%, transparent 50%);
            animation: pulse 8s infinite;
        }
        
        .footer-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(220px, 1fr));  /* CHHOTA */
            gap: 30px;  /* CHHOTA */
            margin-bottom: 30px;  /* CHHOTA */
            position: relative;
            z-index: 2;
        }
        
        .footer-section h3 {
            color: var(--secondary);
            margin-bottom: 15px;  /* CHHOTA */
            padding-bottom: 10px;  /* CHHOTA */
            border-bottom: 2px solid rgba(212, 175, 55, 0.3);
            font-size: 1.2rem;  /* CHHOTA - pehle 1.4rem */
        }
        
        .contact-list {
            display: flex;
            flex-direction: column;
            gap: 12px;  /* CHHOTA */
        }
        
        .contact-item {
            display: flex;
            align-items: flex-start;
            gap: 10px;  /* CHHOTA */
            color: #e0e0e0;
            transition: var(--transition);
            font-size: 0.9rem;  /* CHHOTA */
        }
        
        .contact-item:hover {
            transform: translateX(-5px);
            color: white;
        }
        
        .contact-item i {
            color: var(--secondary);
            font-size: 1.1rem;  /* CHHOTA */
        }
        
        .social-links {
            display: flex;
            gap: 10px;  /* CHHOTA */
            margin-top: 15px;  /* CHHOTA */
        }
        
        .social-links a {
            color: white;
            background: rgba(255, 255, 255, 0.15);
            width: 35px;  /* CHHOTA */
            height: 35px;  /* CHHOTA */
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            text-decoration: none;
            transition: var(--transition);
            font-size: 1rem;  /* CHHOTA */
        }
        
        .social-links a:hover {
            background: var(--secondary);
            color: var(--dark);
            transform: translateY(-5px) scale(1.1);
        }
        
        .copyright {
            text-align: center;
            padding-top: 20px;  /* CHHOTA */
            border-top: 1px solid rgba(255, 255, 255, 0.1);
            color: rgba(255, 255, 255, 0.7);
            position: relative;
            z-index: 2;
            font-size: 0.85rem;  /* CHHOTA */
        }
        
        /* Responsive Design */
        @media (max-width: 768px) {
            .nav-toggle {
                display: block;
            }
            
            .nav-links {
                display: none;
                flex-direction: column;
                width: 100%;
                gap: 5px;  /* CHHOTA */
                padding: 15px 0;  /* CHHOTA */
                background: white;
                position: absolute;
                top: 100%;
                left: 0;
                right: 0;
                box-shadow: 0 8px 15px rgba(0,0,0,0.1);  /* CHHOTA */
                animation: slideDown 0.4s ease-out;
            }
            
            .nav-links.active {
                display: flex;
            }
            
            .nav-links li {
                width: 100%;
                text-align: center;
            }
            
            .nav-links a {
                justify-content: center;
                padding: 12px;  /* CHHOTA */
            }
            
            .hero-content h2 {
                font-size: 1.8rem;  /* CHHOTA */
            }
            
            .hero-buttons {
                flex-direction: column;
                align-items: center;
            }
            
            .btn {
                width: 100%;
                max-width: 250px;  /* CHHOTA */
                justify-content: center;
            }
            
            .form-row {
                grid-template-columns: 1fr;
            }
            
            .institute-logo {
                flex-direction: column;
                gap: 10px;  /* CHHOTA */
            }
            
            .institute-name h1 {
                font-size: 1.5rem;  /* CHHOTA */
            }
            
            .announcements-grid {
                grid-template-columns: 1fr;
            }
        }

        /* Submit Page Overlay */
        .submit-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.85);
            backdrop-filter: blur(5px);
            z-index: 999999;
            display: none;
            justify-content: center;
            align-items: center;
            flex-direction: column;
        }

        .submit-overlay.active {
            display: flex;
        }

        .submit-spinner {
            width: 60px;  /* CHHOTA */
            height: 60px;  /* CHHOTA */
            border: 5px solid rgba(212, 175, 55, 0.2);  /* CHHOTA */
            border-top: 5px solid #d4af37;  /* CHHOTA */
            border-right: 5px solid #d4af37;  /* CHHOTA */
            border-radius: 50%;
            animation: spin 1s linear infinite;
            margin-bottom: 15px;  /* CHHOTA */
            box-shadow: 0 0 15px rgba(212, 175, 55, 0.3);  /* CHHOTA */
        }

        .submit-message {
            color: white;
            font-size: 1.3rem;  /* CHHOTA - pehle 1.6rem */
            font-weight: 600;
            text-align: center;
            line-height: 1.8;
            text-shadow: 2px 2px 4px rgba(0,0,0,0.5);
        }

        .submit-message small {
            display: block;
            font-size: 0.95rem;  /* CHHOTA */
            color: #d4af37;
            margin-top: 8px;  /* CHHOTA */
            opacity: 0.9;
        }

        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }

        button[type="submit"]:disabled {
            opacity: 0.6;
            cursor: not-allowed;
            transform: scale(0.98);
        }

        /* Fix zoom issue - VERY IMPORTANT */
        * {
            box-sizing: border-box;
        }

        body, input, textarea, select, button, p, h1, h2, h3, h4, span, div, label, a, li {
            font-family: 'Noto Nastaliq Urdu', 'Noto Naskh Arabic', sans-serif;
        }

        /* Fix for icons */
        .fas, .far, .fab, .fa {
            font-family: 'Font Awesome 5 Free', 'Font Awesome 5 Brands' !important;
            font-weight: 900 !important;
        }
        
        /* SAB SE ASAN TARIQA */
.form-section input,
.form-section select,
.form-section textarea,
.form-section label,
.form-section button,
.form-section p,
.form-section div {
    font-size: 12px !important;
}
        
        
        /* ========== اعلان داخلہ سیکشن فکس ========== */

/* Main wrapper */
.announcements-wrapper {
    padding: 40px 20px !important;  /* pehle 80px tha */
}

/* Header box */
.header-box {
    margin-bottom: 30px !important;  /* pehle 60px tha */
}

.header-box h2 {
    font-size: 2rem !important;  /* pehle 3.5rem tha */
    margin: 0 !important;
}

.header-box p {
    font-size: 1.1rem !important;  /* pehle 1.4rem tha */
}

/* Cards grid */
.announcements-grid {
    gap: 20px !important;  /* pehle 30px tha */
}

/* Individual card */
.modern-card {
    padding: 25px 20px !important;  /* pehle 40px 30px tha */
}

.card-icon {
    font-size: 2rem !important;  /* pehle 2.5rem tha */
    margin-bottom: 15px !important;
}

.modern-card h3 {
    font-size: 1.5rem !important;  /* pehle 2rem tha */
    margin-bottom: 15px !important;
    padding-bottom: 10px !important;
}

.modern-card li {
    font-size: 0.95rem !important;  /* pehle 1.1rem tha */
    margin-bottom: 12px !important;
    line-height: 1.5 !important;
}

.date-span {
    font-size: 1rem !important;  /* pehle 1.2rem tha */
}

.time-tag {
    padding: 4px 15px !important;  /* pehle 5px 20px tha */
    font-size: 0.9rem !important;
}

/* Featured card text */
.featured-card p {
    font-size: 1.1rem !important;  /* pehle 1.3rem tha */
}
        
    @media (min-width: 1024px) {
    /* 1. File upload aur baki rows ko line mein lane ke liye grid hatayein */
    .form-row {
        display: block !important;
    }

    .form-group {
        width: 100% !important;
        margin-bottom: 20px !important;
    }

    /* 2. Declaration aur Notes ko full width de kar aik ke niche aik karein */
    .declaration-box, .notes-section {
        width: 100% !important;
        margin: 25px 0 !important;
        float: none !important;
        display: block !important;
    }

    /* 3. Instructions (Hifz/Dastawezat) ko laptop par aik line mein 3 columns mein rakhein */
    .notes-grid {
        display: grid !important;
        grid-template-columns: 1fr 1fr 1fr !important;
        gap: 15px !important;
    }

    /* 4. Submit Button ko center mein laane ke liye */
    #submitBtn {
        display: block !important;
        margin: 0 auto !important;
    }
}    
        
        
        
        
        
        
        
    </style>
</head>
<body class="urdu">
    <!-- Language Switcher -->
    <div class="lang-switcher">
        <button class="lang-btn active" onclick="switchLanguage('urdu')">اردو</button>
        <button class="lang-btn" onclick="switchLanguage('english')">English</button>
    </div>

    <!-- HEADER -->
    <header class="main-header">
        <div class="container">
            <div class="header-content">
                <div class="institute-logo">
                    <div class="logo-icon float">
                        <i class="fas fa-mosque"></i>
                    </div>
                    <div class="institute-name">
                        <h1 id="instituteName">جامعہ دارالعلوم حقانیہ اکوڑہ خٹک</h1>
                        <div class="institute-subtitle" id="instituteSubtitle">جامعہ دارالعلوم حقانیہ - عالمی مرکز برائے علوم اسلامیہ</div>
                        <div class="academic-year" id="academicYear">تعلیمی سال 1447-48ھ | 2026-27ء</div>
                    </div>
                </div>
            </div>
        </div>
    </header>
    
    <!-- NAVIGATION -->
    <nav class="main-nav">
        <div class="container nav-container">
            <div class="nav-toggle" id="navToggle">
                <i class="fas fa-bars"></i>
            </div>
            <ul class="nav-links" id="navLinks">
                <li><a href="#home" class="active" id="navHome"><i class="fas fa-home"></i> <span>ہوم</span></a></li>
                <li><a href="#admission" id="navAdmission"><i class="fas fa-file-alt"></i> <span>داخلہ فارم</span></a></li>
                <li><a href="#announcements" id="navAnnouncements"><i class="fas fa-bullhorn"></i> <span>اعلانات</span></a></li>
                <li><a href="#contact" id="navContact"><i class="fas fa-phone"></i> <span>رابطہ</span></a></li>
            </ul>
        </div>
    </nav>
    
    <!-- HERO SECTION -->
    <section class="hero-section" id="home">
        <div class="container">
            <div class="hero-content">
                <h2 id="heroTitle">جامعہ دارالعلوم حقانیہ اکوڑہ خٹک میں خوش آمدید</h2>
                <p id="heroDesc">بین الاقوامی سطح پر معروف اسلامی تعلیمی ادارہ جو 1947ء سے علوم اسلامیہ کی تدریس و تشہیر میں مصروف ہے۔</p>
                <div class="hero-buttons">
                    <a href="#admission" class="btn btn-primary" id="heroBtn1"><i class="fas fa-edit"></i> داخلہ فارم بھریں</a>
                    <a href="#announcements" class="btn btn-secondary" id="heroBtn2"><i class="fas fa-newspaper"></i> تازہ اعلانات</a>
                </div>
            </div>
        </div>
    </section>
    
    <!-- ANNOUNCEMENTS SECTION -->
 <link href="https://fonts.googleapis.com/css2?family=Noto+Nastaliq+Urdu:wght@400;700&display=swap" rel="stylesheet">

<style>
    :root {
        --dark-green: #064e3b;
        --gold: #c5a059;
        --bg-color: #fcfaf2;
        --card-bg: #ffffff;
    }

    .announcements-wrapper {
        background-color: var(--bg-color);
        /* ہلکا اسلامی پیٹرن */
        background-image: url('https://www.transparenttextures.com/patterns/arabesque.png'); 
        padding: 80px 20px;
        direction: rtl;
        font-family: 'Jameel Noori Nastaleeq', 'Noto Nastaliq Urdu', serif;
    }

    .container {
        max-width: 1200px;
        margin: 0 auto;
    }

    .header-box {
        text-align: center;
        margin-bottom: 60px;
        position: relative;
    }

    .header-box h2 {
        color: var(--dark-green);
        font-size: 3.5rem;
        margin: 0;
        text-shadow: 2px 2px 4px rgba(0,0,0,0.1);
    }

    .header-box p {
        color: var(--gold);
        font-size: 1.4rem;
        font-weight: bold;
        letter-spacing: 1px;
    }

    /* 3 Card Grid */
    .announcements-grid {
        display: grid;
        grid-template-columns: repeat(3, 1fr);
        gap: 30px;
    }

    .modern-card {
        background: var(--card-bg);
        border-radius: 20px;
        padding: 40px 30px;
        text-align: center;
        box-shadow: 0 20px 40px rgba(0,0,0,0.08);
        border: 1px solid rgba(197, 160, 89, 0.3);
        transition: all 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275);
        position: relative;
    }

    .modern-card:hover {
        transform: translateY(-15px);
        box-shadow: 0 30px 60px rgba(6, 78, 59, 0.15);
        border-color: var(--gold);
    }

    .card-icon {
        font-size: 2.5rem;
        margin-bottom: 20px;
        display: block;
    }

    .modern-card h3 {
        color: var(--dark-green);
        font-size: 2rem;
        margin-bottom: 25px;
        position: relative;
        padding-bottom: 15px;
    }

    .modern-card h3::after {
        content: '';
        position: absolute;
        bottom: 0; left: 25%; right: 25%;
        height: 2px;
        background: linear-gradient(to right, transparent, var(--gold), transparent);
    }

    .modern-card ul {
        list-style: none;
        padding: 0;
    }

    .modern-card li {
        margin-bottom: 20px;
        font-size: 1.1rem;
        color: #444;
        line-height: 1.8;
    }

    .date-span {
        display: block;
        color: var(--gold);
        font-weight: bold;
        font-size: 1.2rem;
    }

    /* Special Highlight for Hifz */
    .featured-card {
        background: var(--dark-green);
        color: white;
    }

    .featured-card h3 { color: var(--gold); }
    .featured-card li { color: #e0e0e0; }
    .featured-card .date-span { color: #fff; }

    .time-tag {
        background: var(--gold);
        color: white;
        padding: 5px 20px;
        border-radius: 50px;
        display: inline-block;
        margin-top: 15px;
    }

    /* Mobile Responsive */
    @media (max-width: 992px) {
        .announcements-grid { grid-template-columns: 1fr; }
        .header-box h2 { font-size: 2.5rem; }
    }
</style>

<section class="announcements-wrapper">
    <div class="container">
        
        <div class="header-box">
            <h2>📢 اعلانِ داخلہ</h2>
            <p>جامعہ دارالعلوم حقانیہ اکوڑہ خٹک</p>
            <p style="font-size: 1.1rem; color: #666;">تعلیمی سال 1447-1448ھ / 2026-2027ء</p>
        </div>

        <div class="announcements-grid">

            <div class="modern-card">
                <span class="card-icon">🕌</span>
                <h3>شعبہ بنین (طلبہ)</h3>
                <ul>
                    <li>قدیم طلبہ (تمام درجات) <span class="date-span">10 شوال | 30 مارچ</span></li>
                    <li>جدید دورہ حدیث شریف <span class="date-span">11-12 شوال | 31 مارچ</span></li>
                    <li>موقوف علیہ، اولیٰ، ثانیہ، ثالثہ
  <span class="date-span">13 شوال | 2 اپریل</span></li>
                    <li>سادسہ، رابعہ، خامسہ، تکمیل
 <span class="date-span">15 شوال | 4 اپریل</span></li>
                </ul>
            </div>

            <div class="modern-card featured-card">
                <span class="card-icon">📖</span>
                <h3>شعبہ حفظ (ٹیسٹ)</h3>
                <p style="font-size: 1.3rem;">داخلہ ٹیسٹ و انٹرویو</p>
                <ul>
                    <li>تاریخ: <span class="date-span">12-13 شوال | 1-2 اپریل</span></li>
                    <li>بروز: <span class="date-span">بدھ اور جمعرات</span></li>
                </ul>
                <div class="time-tag">وقت: صبح 9:00 بجے</div>
            </div>

            <div class="modern-card">
                <span class="card-icon">📜</span>
                <h3>دیگر شعبہ جات</h3>
                <ul>
                    <li>تخصص فی الفقہ والافتاء <span class="date-span">16 شوال | 5 اپریل</span></li>
                    <li>تخصص فی الحدیث، اللغۃ العربیۃ، تخصص فی التفسیر
</li><span class="date-span">18 شوال | 7 اپریل</span></li>

                    <li> درجہ تمہیدیہ – معہد اللغۃ العربیۃ <span class="date-span">17 شوال | 6 اپریل</span></li>
                    
                    <li>تجوید (حفاظ و علماء) <span class="date-span">19 شوال | 8 اپریل</span></li>
                </ul>
            </div>

        </div>
    </div>
</section>
    
    
 <!-- ========== DOWNLOAD FORM SECTION ========== -->
<div style="background-color:#0a4b33; color:#d4af37; padding: 30px 20px; text-align: center; border-radius: 20px; max-width: 800px; margin: 40px auto; font-family: 'Segoe UI', Tahoma, sans-serif;">

    <!-- Headline -->
    <div style="font-size: 20px; font-weight: bold; margin-bottom: 10px;">
        ★ خصوصی سہولت برائے طلبہ
    </div>

    <!-- Main Title -->
    <div style="font-size: 28px; font-weight: bold; margin-bottom: 20px; line-height: 1.4;">
        اپنا فارم خود ڈاؤن لوڈ کریں
    </div>

    <!-- Instruction Text -->
    <div style="font-size: 16px; margin-bottom: 25px; line-height: 1.8; color: #ffffffcc; max-width: 600px; margin-left: auto; margin-right: auto;">
        اگر آپ نے فارم جمع کروایا لیکن ڈاؤن لوڈ نہیں ہو رہا، تو یہاں کلک کریں اور اپنا فارم خود ڈاؤن لوڈ کریں۔
    </div>
    
    <!-- WhatsApp Line - FIXED WITH LTR DIRECTION -->
    <div style="font-size: 18px; margin-bottom: 25px; color: #ffffff; background-color: rgba(212, 175, 55, 0.2); padding: 10px 20px; border-radius: 50px; display: inline-block;">
        📱 مسئلہ کی صورت میں WhatsApp کریں: 
        <span style="color: #d4af37; font-weight: bold; font-size: 22px; margin-right: 5px; direction: ltr; display: inline-block;">0334-8845727</span>
    </div>

    <!-- Download Button -->
    <div>
        <a href="download-form.php" style="
            display: inline-block; 
            background-color: #d4af37; 
            color: #0a4b33; 
            padding: 14px 45px; 
            border-radius: 50px; 
            font-weight: bold; 
            font-size: 18px; 
            text-decoration: none;
            transition: transform 0.3s ease, box-shadow 0.3s ease;
        " 
        onmouseover="this.style.transform='scale(1.05)'; this.style.boxShadow='0 5px 15px rgba(0,0,0,0.3)';" 
        onmouseout="this.style.transform='scale(1)'; this.style.boxShadow='none';">
            ⬅ یہاں کلک کریں
        </a>
    </div>

</div>
    
    
    
    
    
    
    
    
    
    
<!-- ADMISSION FORM SECTION - FIXED ZOOM ISSUE -->
<section class="form-section" id="admission">
    <div class="container">
        <div class="section-title">
            <h2><i class="fas fa-file-alt"></i> <span id="formTitle">آن لائن داخلہ فارم</span></h2>
            <p id="formSubtitle">براہ کرم درج ذیل فارم مکمل بھریں</p>
        </div>
        
        <div class="form-container">
            <div class="form-header">
                <h3><i class="fas fa-user-graduate"></i> <span id="formHeader">داخلہ فارم 2026-27</span></h3>
            </div>
            
            <div class="form-body">
                <form method="POST" action="submit.php" enctype="multipart/form-data">
                    
                    <!-- ========== BASIC INFO ========== -->
                    <div class="form-row">
                        <div class="form-group">
                            <label class="form-label"><i class="fas fa-user"></i> طالب علم کا مکمل نام</label>
                            <input type="text" name="student_name" class="form-control" required>
                        </div>
                        <div class="form-group">
                            <label class="form-label"><i class="fas fa-user-friends"></i> والد کا نام</label>
                            <input type="text" name="father_name" class="form-control" required>
                        </div>
                    </div>
                    
                    <!-- ========== شناختی کارڈ نمبر (CNIC) ========== -->
<div class="form-row">
    <div class="form-group">
        <label class="form-label"><i class="fas fa-id-card"></i> شناختی کارڈ نمبر</label>
        <input type="text" name="cnic_number" class="form-control" placeholder="12345-1234567-1" maxlength="15">
    </div>
</div>
                    <!-- ========== DOB + DISTRICT + COUNTRY ========== -->
                    <div class="form-row">
                        <div class="form-group">
                            <label class="form-label"><i class="fas fa-calendar-alt"></i> تاریخ پیدائش</label>
                            <input type="date" name="dob" class="form-control" required>
                        </div>
                        <div class="form-group">
                            <label class="form-label"><i class="fas fa-map-marker-alt"></i> ضلع</label>
                            <input type="text" name="district" class="form-control" placeholder="نوشہرہ، پشاور، صوابی" required>
                        </div>
                        <div class="form-group">
                            <label class="form-label"><i class="fas fa-globe"></i> ملک</label>
                            <select name="country" class="form-control" required>
                                <option value="">-- منتخب کریں --</option>
                                <option value="پاکستان" selected>پاکستان</option>
                                <option value="افغانستان">افغانستان</option>
                                <option value="بھارت">بھارت</option>
                                <option value="بنگلہ دیش">بنگلہ دیش</option>
                                <option value="دیگر">دیگر</option>
                            </select>
                        </div>
                    </div>
                    
                    <!-- ========== PERMANENT + CURRENT ADDRESS ========== -->
                    <div class="form-row">
                        <div class="form-group">
                            <label class="form-label"><i class="fas fa-map-marker-alt"></i> مستقل پتہ</label>
                            <textarea name="permanent_address" class="form-control" required></textarea>
                        </div>
                        <div class="form-group">
                            <label class="form-label"><i class="fas fa-map-location-dot"></i> موجودہ پتہ</label>
                            <textarea name="current_address" class="form-control" required></textarea>
                        </div>
                    </div>
                    
                    <!-- ========== GUARDIAN INFO ========== -->
                    <div class="form-row">
                        <div class="form-group">
                            <label class="form-label"><i class="fas fa-user-tie"></i> ولی/سرپرست کا نام</label>
                            <input type="text" name="guardian_name" class="form-control" required>
                        </div>
                        <div class="form-group">
                            <label class="form-label"><i class="fas fa-phone"></i> فون نمبر</label>
                            <input type="tel" name="phone" class="form-control" required>
                        </div>
                        
                    </div>
                    
                    <!-- ========== NEW: GUARDIAN PHONE ========== -->
                    <div class="form-row">
    <div class="form-group" style="width: 100%;">
        <label class="form-label"><i class="fas fa-phone-alt"></i> سرپرست کا موبائل نمبر</label>
        <input type="tel" name="guardian_phone" class="form-control" placeholder="0300-1234567" style="text-align: right; direction: rtl;">
    </div>
</div>
                    
                    <!-- ========== COURSE ========== -->
                    <div class="form-row">
                        <div class="form-group">
                            <label class="form-label"><i class="fas fa-book-open"></i> مطلوبہ شعبہ</label>
                            <select name="course_applied" class="form-control" required>
                                <option value="حفظ">حفظ</option>
    <option value="درجہ تمہیدیہ">درجہ تمہیدیہ</option>
    <option value="اولیٰ">اولیٰ</option>
    <option value="اولیٰ / عربی">اولیٰ / عربی</option>
    <option value="ثانیہ">ثانیہ</option>
    <option value="ثانیہ / عربی">ثانیہ / عربی</option>
    <option value="ثالثہ">ثالثہ</option>
    <option value="رابعہ">رابعہ</option>
    <option value="خامسہ">خامسہ</option>
    <option value="سادسہ">سادسہ</option>
    <option value="موقوف علیہ / اردو">موقوف علیہ / اردو</option>
    <option value="موقوف علیہ">موقوف علیہ</option>
    <option value="دورہ حدیث / اردو">دورہ حدیث / اردو</option>
    <option value="دورہ حدیث">دورہ حدیث</option>

    <option value="تخصص فی الفقہ">تخصص فی الفقہ</option>
    <option value="تخصص فی التفسیر">تخصص فی التفسیر</option>
    <option value="تخصص فی الحدیث">تخصص فی الحدیث</option>
    <option value="تخصص فی اللغۃ العربیہ">تخصص فی اللغۃ العربیہ</option>
    <option value="تخصص فی الدعوۃ والعقیدہ">تخصص فی الدعوۃ والعقیدہ</option>
    <option value="تجوید للحفاظ">تجوید للحفاظ</option>
    <option value="تجوید للعلماء">تجوید للعلماء</option>ion>
                            </select>
                        </div>
                    </div>

                    <!-- ========== EDUCATION SECTION ========== -->
                    <div class="form-row" style="margin-top: 30px;">
                        <div class="form-group" style="width: 100%;">
                            <h3 style="color: var(--primary); border-right: 5px solid var(--gold); padding-right: 15px;">
                                <i class="fas fa-graduation-cap"></i> تعلیمی کیفیت
                            </h3>
                        </div>
                    </div>

                    <!-- Previous Madrasa -->
                    <div class="form-group">
                        <label class="form-label"><i class="fas fa-map-marker-alt"></i> جس مدرسے کو چھوڑ کر آیا ہے اس کا پتہ</label>
                        <textarea name="previous_madrasa_address" class="form-control" placeholder="مدرسے کا مکمل پتہ" rows="2"></textarea>
                    </div>

                    <!-- Previous Class + Roll No -->
                    <div class="form-row">
                        <div class="form-group">
                            <label class="form-label"><i class="fas fa-layer-group"></i> سابقہ درجہ</label>
                            <input type="text" name="previous_class" class="form-control" placeholder="مثلاً: ثالثہ، خامسہ">
                        </div>
                        <div class="form-group">
                            <label class="form-label"><i class="fas fa-hashtag"></i> وفاق کا رول نمبر</label>
                            <input type="text" name="wifaq_roll_no" class="form-control" placeholder="وفاق کا رول نمبر">
                        </div>
                    </div>

                    <!-- Marks + Division -->
                    <div class="form-row">
                        <div class="form-group">
                            <label class="form-label"><i class="fas fa-star"></i> حاصل کردہ نمبرات</label>
                            <input type="text" name="obtained_marks" class="form-control" placeholder="مثلاً: 850/1100">
                        </div>
                        <div class="form-group">
                            <label class="form-label"><i class="fas fa-trophy"></i> تقدیر</label>
                            <select name="division" class="form-control">
                                <option value="ممتاز">ممتاز</option>>
                                <option value="جید جداً">جید جداً</option>
                                <option value="جید">جید</option>
                            </select>
                        </div>
                    </div>

                    <!-- Asri Taleem -->
                    <div class="form-group">
                        <label class="form-label"><i class="fas fa-calendar-alt"></i> عصری تعلیم</label>
                        <input type="text" name="asri_taleem" class="form-control" placeholder="میٹرک، ایف اے وغیرہ">
                    </div>
                    
                    <!-- ========== FILE UPLOADS ========== -->
                    <div class="form-row">
                        <div class="form-group">
                            <label class="form-label"><i class="fas fa-camera"></i> تصویر</label>
                            <div class="file-upload-container">
                                <div class="file-input-wrapper">
                                    <input type="file" name="photo" class="file-input" accept=".jpg,.jpeg,.png" required>
                                    <label class="file-label">
                                        <i class="fas fa-cloud-arrow-up"></i> فائل منتخب کریں
                                    </label>
                                </div>
                                <span class="file-info">پاسپورٹ سائز تصویر (JPG/PNG, max 2MB)</span>
                            </div>
                        </div>

                        

                        
                    
                    <!-- DECLARATION BOX -->
                    <div class="declaration-box">
                        <div class="declaration-content">
                            <div class="news-heading" id="newsHeading">خوشخبری:</div>
                            <p class="news-text" id="newsText">
                                امسال جامعہ میں درجۂ موقوف علیہ اور دورۂ حدیث کے اسباق اردو میں بھی پڑھائے جائیں گے۔
                            </p>
                        </div>
                    </div>
                    
                    <!-- NOTES SECTION -->
                    <div class="notes-section">
                        <div class="notes-header">
                            <i class="fas fa-lightbulb"></i>
                            <h3 id="notesHeader">اہم ہدایات</h3>
                        </div>
                        <div class="notes-grid">
                            <div class="note-item">
                                <h4><i class="fas fa-quran"></i> <span id="note1Title">حفظ القرآن</span></h4>
                                <p id="note1Text">قرآن ناظرہ مکمل ہونا ضروری ہے۔ عمر 13 سال سے زیادہ نہ ہو۔</p>
                            </div>
                            <div class="note-item">
                                <h4><i class="fas fa-certificate"></i> <span id="note2Title">دستاویزات</span></h4>
                                <p id="note2Text">نادرا شناختی کارڈ اور پاسپورٹ سائز تصویریں لازمی ہیں۔</p>
                            </div>
                            <div class="note-item">
                                <h4><i class="fas fa-file-check"></i> <span id="note3Title">سند</span></h4>
                                <p id="note3Text">سابقہ تعلیمی اسناد منسلک کریں۔</p>
                            </div>
                        </div>
                    </div>
                    
                    <!-- SUBMIT BUTTON -->
                    <div style="text-align: center; margin-top: 40px;">
                        <button type="submit" name="submit_application" class="btn btn-primary" style="padding: 15px 50px; font-size: 1.2rem;" id="submitBtn">
                            <i class="fas fa-paper-plane"></i> درخواست جمع کریں
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</section>
    
    <!-- FOOTER -->
    <footer class="main-footer" id="contact">
        <div class="container">
            <div class="footer-grid">
                <div class="footer-section">
                    <h3 id="footerAbout">جامعہ دارالعلوم حقانیہ اکوڑہ خٹک</h3>
                    <p id="footerDesc">اسلامی تعلیم و تربیت کا عالمی مرکز</p>
                    <p><strong id="footerEst">تاسیس:</strong> 1947ء</p>
                </div>
                
                <div class="footer-section">
                    <h3 id="footerContact">رابطہ کی معلومات</h3>
                    <div class="contact-list">
                        <div class="contact-item">
                            <i class="fas fa-phone"></i>
                            <span>+92 303 5510000</span>
                        </div>
                        <div class="contact-item">
                            <i class="fas fa-envelope"></i>
                            <span>admission@darululoomhaqqania.com</span>
                        </div>
                        <div class="contact-item">
                            <i class="fas fa-location-dot"></i>
                            <span id="footerAddress">گرینڈ ٹرنک روڈ، اکوڑہ خٹک، نوشہرہ، پاکستان</span>
                        </div>
                    </div>
                </div>
                
                <div class="footer-section">
                    <h3 id="footerHours">اوقات کار</h3>
                    <p id="hours1">ہفتہ سے جمعرات: صبح 8:00 تا شام 5:00</p>
                    <p id="hours2">جمعہ: صبح 9:00 تا دوپہر 1:00</p>
                </div>
            </div>
            
            <div class="copyright">
                <p id="copyright">© 2026 جامعہ دارالعلوم حقانیہ اکوڑہ خٹک۔ تمام حقوق محفوظ ہیں۔</p>
            </div>
        </div>
    </footer>
<script>
// Bus 1 line ka kaam - form submit pe overlay dikhao
document.querySelector('form').addEventListener('submit', function() {
    document.getElementById('loadingOverlay').style.display = 'block';
});
</script>
      
</body>
</html>